// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.paginators

import aws.sdk.kotlin.services.pi.PiClient
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysRequest
import aws.sdk.kotlin.services.pi.model.DescribeDimensionKeysResponse
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceDimensionsResponse
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsRequest
import aws.sdk.kotlin.services.pi.model.ListAvailableResourceMetricsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeDimensionKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDimensionKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDimensionKeysResponse]
 */
fun PiClient.describeDimensionKeysPaginated(initialRequest: DescribeDimensionKeysRequest): Flow<DescribeDimensionKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDimensionKeysPaginated.describeDimensionKeys(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDimensionKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDimensionKeysResponse]
 */
fun PiClient.describeDimensionKeysPaginated(block: DescribeDimensionKeysRequest.Builder.() -> Unit): Flow<DescribeDimensionKeysResponse> =
    describeDimensionKeysPaginated(DescribeDimensionKeysRequest.Builder().apply(block).build())

/**
 * Paginate over [GetResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetResourceMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceMetricsResponse]
 */
fun PiClient.getResourceMetricsPaginated(initialRequest: GetResourceMetricsRequest): Flow<GetResourceMetricsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getResourceMetricsPaginated.getResourceMetrics(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourceMetricsResponse]
 */
fun PiClient.getResourceMetricsPaginated(block: GetResourceMetricsRequest.Builder.() -> Unit): Flow<GetResourceMetricsResponse> =
    getResourceMetricsPaginated(GetResourceMetricsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAvailableResourceDimensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAvailableResourceDimensionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceDimensionsResponse]
 */
fun PiClient.listAvailableResourceDimensionsPaginated(initialRequest: ListAvailableResourceDimensionsRequest): Flow<ListAvailableResourceDimensionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAvailableResourceDimensionsPaginated.listAvailableResourceDimensions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAvailableResourceDimensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceDimensionsResponse]
 */
fun PiClient.listAvailableResourceDimensionsPaginated(block: ListAvailableResourceDimensionsRequest.Builder.() -> Unit): Flow<ListAvailableResourceDimensionsResponse> =
    listAvailableResourceDimensionsPaginated(ListAvailableResourceDimensionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAvailableResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAvailableResourceMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceMetricsResponse]
 */
fun PiClient.listAvailableResourceMetricsPaginated(initialRequest: ListAvailableResourceMetricsRequest): Flow<ListAvailableResourceMetricsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAvailableResourceMetricsPaginated.listAvailableResourceMetrics(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAvailableResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAvailableResourceMetricsResponse]
 */
fun PiClient.listAvailableResourceMetricsPaginated(block: ListAvailableResourceMetricsRequest.Builder.() -> Unit): Flow<ListAvailableResourceMetricsResponse> =
    listAvailableResourceMetricsPaginated(ListAvailableResourceMetricsRequest.Builder().apply(block).build())
