// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pi.model.DimensionKeyDetail
import aws.sdk.kotlin.services.pi.model.GetDimensionKeyDetailsResponse
import aws.sdk.kotlin.services.pi.model.PiException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDimensionKeyDetailsOperationDeserializer: HttpDeserialize<GetDimensionKeyDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDimensionKeyDetailsResponse {
        if (!response.status.isSuccess()) {
            throwGetDimensionKeyDetailsError(context, response)
        }
        val builder = GetDimensionKeyDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDimensionKeyDetailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDimensionKeyDetailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PiException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDimensionKeyDetailsOperationBody(builder: GetDimensionKeyDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DIMENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Dimensions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIMENSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DIMENSIONS_DESCRIPTOR.index -> builder.dimensions =
                    deserializer.deserializeList(DIMENSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DimensionKeyDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDimensionKeyDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
