// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pi.model.FeatureMetadata
import aws.sdk.kotlin.services.pi.model.GetResourceMetadataResponse
import aws.sdk.kotlin.services.pi.model.PiException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourceMetadataOperationDeserializer: HttpDeserialize<GetResourceMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResourceMetadataResponse {
        if (!response.status.isSuccess()) {
            throwGetResourceMetadataError(context, response)
        }
        val builder = GetResourceMetadataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceMetadataOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResourceMetadataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PiException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceMetadataOperationBody(builder: GetResourceMetadataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Features"))
    val IDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Identifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FEATURES_DESCRIPTOR)
        field(IDENTIFIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FEATURES_DESCRIPTOR.index -> builder.features =
                    deserializer.deserializeMap(FEATURES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FeatureMetadata>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFeatureMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                IDENTIFIER_DESCRIPTOR.index -> builder.identifier = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
