// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pi.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pi.model.GetResourceMetricsResponse
import aws.sdk.kotlin.services.pi.model.MetricKeyDataPoints
import aws.sdk.kotlin.services.pi.model.PiException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetResourceMetricsOperationDeserializer: HttpDeserialize<GetResourceMetricsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResourceMetricsResponse {
        if (!response.status.isSuccess()) {
            throwGetResourceMetricsError(context, response)
        }
        val builder = GetResourceMetricsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceMetricsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResourceMetricsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PiException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceMetricsOperationBody(builder: GetResourceMetricsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIGNEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedEndTime"))
    val ALIGNEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("AlignedStartTime"))
    val IDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Identifier"))
    val METRICLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MetricList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIGNEDENDTIME_DESCRIPTOR)
        field(ALIGNEDSTARTTIME_DESCRIPTOR)
        field(IDENTIFIER_DESCRIPTOR)
        field(METRICLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIGNEDENDTIME_DESCRIPTOR.index -> builder.alignedEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ALIGNEDSTARTTIME_DESCRIPTOR.index -> builder.alignedStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                IDENTIFIER_DESCRIPTOR.index -> builder.identifier = deserializeString()
                METRICLIST_DESCRIPTOR.index -> builder.metricList =
                    deserializer.deserializeList(METRICLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricKeyDataPoints>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricKeyDataPointsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
