// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.*
import aws.sdk.kotlin.services.pinpointsmsvoicev2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Pinpoint SMS Voice V2"
public const val ServiceApiVersion: String = "2022-03-31"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultPinpointSmsVoiceV2Client(override val config: PinpointSmsVoiceV2Client.Config) : PinpointSmsVoiceV2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates the specified origination identity with a pool.
     *
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
     *
     * If the origination identity configuration doesn't match the pool's configuration, an Error is returned.
     */
    override suspend fun associateOriginationIdentity(input: AssociateOriginationIdentityRequest): AssociateOriginationIdentityResponse {
        val op = SdkHttpOperation.build<AssociateOriginationIdentityRequest, AssociateOriginationIdentityResponse> {
            serializer = AssociateOriginationIdentityOperationSerializer()
            deserializer = AssociateOriginationIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateOriginationIdentity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
     *
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     *
     * When you send a message, you can optionally specify a single configuration set.
     */
    override suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetRequest, CreateConfigurationSetResponse> {
            serializer = CreateConfigurationSetOperationSerializer()
            deserializer = CreateConfigurationSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfigurationSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new event destination in a configuration set.
     *
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     *
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
     */
    override suspend fun createEventDestination(input: CreateEventDestinationRequest): CreateEventDestinationResponse {
        val op = SdkHttpOperation.build<CreateEventDestinationRequest, CreateEventDestinationResponse> {
            serializer = CreateEventDestinationOperationSerializer()
            deserializer = CreateEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new opt-out list.
     *
     * If the opt-out list name already exists, an Error is returned.
     *
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see [ SMS opt out ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout) in the *Amazon Pinpoint User Guide*.
     */
    override suspend fun createOptOutList(input: CreateOptOutListRequest): CreateOptOutListResponse {
        val op = SdkHttpOperation.build<CreateOptOutListRequest, CreateOptOutListResponse> {
            serializer = CreateOptOutListOperationSerializer()
            deserializer = CreateOptOutListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOptOutList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     *
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't inherited from the origination identity and defaults to false.
     *
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
     */
    override suspend fun createPool(input: CreatePoolRequest): CreatePoolResponse {
        val op = SdkHttpOperation.build<CreatePoolRequest, CreatePoolResponse> {
            serializer = CreatePoolOperationSerializer()
            deserializer = CreatePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing configuration set.
     *
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages.
     */
    override suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse> {
            serializer = DeleteConfigurationSetOperationSerializer()
            deserializer = DeleteConfigurationSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConfigurationSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing default message type on a configuration set.
     *
     *  A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
     */
    override suspend fun deleteDefaultMessageType(input: DeleteDefaultMessageTypeRequest): DeleteDefaultMessageTypeResponse {
        val op = SdkHttpOperation.build<DeleteDefaultMessageTypeRequest, DeleteDefaultMessageTypeResponse> {
            serializer = DeleteDefaultMessageTypeOperationSerializer()
            deserializer = DeleteDefaultMessageTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDefaultMessageType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing default sender ID on a configuration set.
     *
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.
     */
    override suspend fun deleteDefaultSenderId(input: DeleteDefaultSenderIdRequest): DeleteDefaultSenderIdResponse {
        val op = SdkHttpOperation.build<DeleteDefaultSenderIdRequest, DeleteDefaultSenderIdResponse> {
            serializer = DeleteDefaultSenderIdOperationSerializer()
            deserializer = DeleteDefaultSenderIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDefaultSenderId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing event destination.
     *
     * An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     */
    override suspend fun deleteEventDestination(input: DeleteEventDestinationRequest): DeleteEventDestinationResponse {
        val op = SdkHttpOperation.build<DeleteEventDestinationRequest, DeleteEventDestinationResponse> {
            serializer = DeleteEventDestinationOperationSerializer()
            deserializer = DeleteEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing keyword from an origination phone number or pool.
     *
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     */
    override suspend fun deleteKeyword(input: DeleteKeywordRequest): DeleteKeywordResponse {
        val op = SdkHttpOperation.build<DeleteKeywordRequest, DeleteKeywordResponse> {
            serializer = DeleteKeywordOperationSerializer()
            deserializer = DeleteKeywordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteKeyword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     *
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an Error is returned.
     */
    override suspend fun deleteOptOutList(input: DeleteOptOutListRequest): DeleteOptOutListResponse {
        val op = SdkHttpOperation.build<DeleteOptOutListRequest, DeleteOptOutListResponse> {
            serializer = DeleteOptOutListOperationSerializer()
            deserializer = DeleteOptOutListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOptOutList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     *
     * Each destination phone number can only be deleted once every 30 days.
     *
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an Error is returned.
     */
    override suspend fun deleteOptedOutNumber(input: DeleteOptedOutNumberRequest): DeleteOptedOutNumberResponse {
        val op = SdkHttpOperation.build<DeleteOptedOutNumberRequest, DeleteOptedOutNumberResponse> {
            serializer = DeleteOptedOutNumberOperationSerializer()
            deserializer = DeleteOptedOutNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOptedOutNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     *
     * If the pool status isn't active or if deletion protection is enabled, an Error is returned.
     *
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     */
    override suspend fun deletePool(input: DeletePoolRequest): DeletePoolResponse {
        val op = SdkHttpOperation.build<DeletePoolRequest, DeletePoolResponse> {
            serializer = DeletePoolOperationSerializer()
            deserializer = DeletePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    override suspend fun deleteTextMessageSpendLimitOverride(input: DeleteTextMessageSpendLimitOverrideRequest): DeleteTextMessageSpendLimitOverrideResponse {
        val op = SdkHttpOperation.build<DeleteTextMessageSpendLimitOverrideRequest, DeleteTextMessageSpendLimitOverrideResponse> {
            serializer = DeleteTextMessageSpendLimitOverrideOperationSerializer()
            deserializer = DeleteTextMessageSpendLimitOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTextMessageSpendLimitOverride"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the `EnforcedLimit` equal to the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see [Amazon Pinpoint quotas](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    override suspend fun deleteVoiceMessageSpendLimitOverride(input: DeleteVoiceMessageSpendLimitOverrideRequest): DeleteVoiceMessageSpendLimitOverrideResponse {
        val op = SdkHttpOperation.build<DeleteVoiceMessageSpendLimitOverrideRequest, DeleteVoiceMessageSpendLimitOverrideResponse> {
            serializer = DeleteVoiceMessageSpendLimitOverrideOperationSerializer()
            deserializer = DeleteVoiceMessageSpendLimitOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVoiceMessageSpendLimitOverride"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     *
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse.
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializer = DescribeAccountAttributesOperationSerializer()
            deserializer = DescribeAccountAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     *
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see [ Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    override suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse {
        val op = SdkHttpOperation.build<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse> {
            serializer = DescribeAccountLimitsOperationSerializer()
            deserializer = DescribeAccountLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified configuration sets or all in your account.
     *
     * If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don't specify configuration set names or filters, the output includes information for all configuration sets.
     *
     * If you specify a configuration set name that isn't valid, an error is returned.
     */
    override suspend fun describeConfigurationSets(input: DescribeConfigurationSetsRequest): DescribeConfigurationSetsResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationSetsRequest, DescribeConfigurationSetsResponse> {
            serializer = DescribeConfigurationSetsOperationSerializer()
            deserializer = DescribeConfigurationSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfigurationSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     *
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * If you specify a keyword that isn't valid, an Error is returned.
     */
    override suspend fun describeKeywords(input: DescribeKeywordsRequest): DescribeKeywordsResponse {
        val op = SdkHttpOperation.build<DescribeKeywordsRequest, DescribeKeywordsResponse> {
            serializer = DescribeKeywordsOperationSerializer()
            deserializer = DescribeKeywordsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeKeywords"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified opt-out list or all opt-out lists in your account.
     *
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the output includes information for all opt-out lists.
     *
     * If you specify an opt-out list name that isn't valid, an Error is returned.
     */
    override suspend fun describeOptOutLists(input: DescribeOptOutListsRequest): DescribeOptOutListsResponse {
        val op = SdkHttpOperation.build<DescribeOptOutListsRequest, DescribeOptOutListsResponse> {
            serializer = DescribeOptOutListsOperationSerializer()
            deserializer = DescribeOptOutListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOptOutLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     *
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.
     *
     * If you specify an opted out number that isn't valid, an Error is returned.
     */
    override suspend fun describeOptedOutNumbers(input: DescribeOptedOutNumbersRequest): DescribeOptedOutNumbersResponse {
        val op = SdkHttpOperation.build<DescribeOptedOutNumbersRequest, DescribeOptedOutNumbersResponse> {
            serializer = DescribeOptedOutNumbersOperationSerializer()
            deserializer = DescribeOptedOutNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOptedOutNumbers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified origination phone number, or all the phone numbers in your account.
     *
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     *
     * If you specify a phone number ID that isn't valid, an Error is returned.
     */
    override suspend fun describePhoneNumbers(input: DescribePhoneNumbersRequest): DescribePhoneNumbersResponse {
        val op = SdkHttpOperation.build<DescribePhoneNumbersRequest, DescribePhoneNumbersResponse> {
            serializer = DescribePhoneNumbersOperationSerializer()
            deserializer = DescribePhoneNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePhoneNumbers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     *
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs or filters, the output includes information for all pools.
     *
     * If you specify a pool ID that isn't valid, an Error is returned.
     *
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     */
    override suspend fun describePools(input: DescribePoolsRequest): DescribePoolsResponse {
        val op = SdkHttpOperation.build<DescribePoolsRequest, DescribePoolsResponse> {
            serializer = DescribePoolsOperationSerializer()
            deserializer = DescribePoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     *
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't specify SenderIds or filters, the output includes information for all SenderIds.
     *
     * f you specify a sender ID that isn't valid, an Error is returned.
     */
    override suspend fun describeSenderIds(input: DescribeSenderIdsRequest): DescribeSenderIdsResponse {
        val op = SdkHttpOperation.build<DescribeSenderIdsRequest, DescribeSenderIdsResponse> {
            serializer = DescribeSenderIdsOperationSerializer()
            deserializer = DescribeSenderIdsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSenderIds"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     *
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see [ Requesting increases to your monthly SMS spending quota for Amazon Pinpoint ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html) in the *Amazon Pinpoint User Guide*.
     */
    override suspend fun describeSpendLimits(input: DescribeSpendLimitsRequest): DescribeSpendLimitsResponse {
        val op = SdkHttpOperation.build<DescribeSpendLimitsRequest, DescribeSpendLimitsResponse> {
            serializer = DescribeSpendLimitsOperationSerializer()
            deserializer = DescribeSpendLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSpendLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified origination identity from an existing pool.
     *
     * If the origination identity isn't associated with the specified pool, an Error is returned.
     */
    override suspend fun disassociateOriginationIdentity(input: DisassociateOriginationIdentityRequest): DisassociateOriginationIdentityResponse {
        val op = SdkHttpOperation.build<DisassociateOriginationIdentityRequest, DisassociateOriginationIdentityResponse> {
            serializer = DisassociateOriginationIdentityOperationSerializer()
            deserializer = DisassociateOriginationIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateOriginationIdentity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all associated origination identities in your pool.
     *
     * If you specify filters, the output includes information for only those origination identities that meet the filter criteria.
     */
    override suspend fun listPoolOriginationIdentities(input: ListPoolOriginationIdentitiesRequest): ListPoolOriginationIdentitiesResponse {
        val op = SdkHttpOperation.build<ListPoolOriginationIdentitiesRequest, ListPoolOriginationIdentitiesResponse> {
            serializer = ListPoolOriginationIdentitiesOperationSerializer()
            deserializer = ListPoolOriginationIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPoolOriginationIdentities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all tags associated with a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates a keyword configuration on an origination phone number or pool.
     *
     *  A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * If you specify a keyword that isn't valid, an Error is returned.
     */
    override suspend fun putKeyword(input: PutKeywordRequest): PutKeywordResponse {
        val op = SdkHttpOperation.build<PutKeywordRequest, PutKeywordResponse> {
            serializer = PutKeywordOperationSerializer()
            deserializer = PutKeywordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutKeyword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an opted out destination phone number in the opt-out list.
     *
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an Error is returned.
     */
    override suspend fun putOptedOutNumber(input: PutOptedOutNumberRequest): PutOptedOutNumberResponse {
        val op = SdkHttpOperation.build<PutOptedOutNumberRequest, PutOptedOutNumberResponse> {
            serializer = PutOptedOutNumberOperationSerializer()
            deserializer = PutOptedOutNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutOptedOutNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.
     *
     * If the origination phone number has deletion protection enabled or is associated with a pool, an Error is returned.
     */
    override suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse {
        val op = SdkHttpOperation.build<ReleasePhoneNumberRequest, ReleasePhoneNumberResponse> {
            serializer = ReleasePhoneNumberOperationSerializer()
            deserializer = ReleasePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleasePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Request an origination phone number for use in your account. For more information on phone number request see [ Requesting a number ](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html) in the *Amazon Pinpoint User Guide*.
     */
    override suspend fun requestPhoneNumber(input: RequestPhoneNumberRequest): RequestPhoneNumberResponse {
        val op = SdkHttpOperation.build<RequestPhoneNumberRequest, RequestPhoneNumberResponse> {
            serializer = RequestPhoneNumberOperationSerializer()
            deserializer = RequestPhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RequestPhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new text message and sends it to a recipient's phone number.
     *
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see [Message Parts per Second (MPS) limits](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html) in the *Amazon Pinpoint User Guide*.
     */
    override suspend fun sendTextMessage(input: SendTextMessageRequest): SendTextMessageResponse {
        val op = SdkHttpOperation.build<SendTextMessageRequest, SendTextMessageResponse> {
            serializer = SendTextMessageOperationSerializer()
            deserializer = SendTextMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendTextMessage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses [Amazon Polly](http://aws.amazon.com/polly/) to convert a text script into a voice message.
     */
    override suspend fun sendVoiceMessage(input: SendVoiceMessageRequest): SendVoiceMessageResponse {
        val op = SdkHttpOperation.build<SendVoiceMessageRequest, SendVoiceMessageResponse> {
            serializer = SendVoiceMessageOperationSerializer()
            deserializer = SendVoiceMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendVoiceMessage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the default message type on a configuration set.
     *
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
     */
    override suspend fun setDefaultMessageType(input: SetDefaultMessageTypeRequest): SetDefaultMessageTypeResponse {
        val op = SdkHttpOperation.build<SetDefaultMessageTypeRequest, SetDefaultMessageTypeResponse> {
            serializer = SetDefaultMessageTypeOperationSerializer()
            deserializer = SetDefaultMessageTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetDefaultMessageType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets default sender ID on a configuration set.
     *
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.
     */
    override suspend fun setDefaultSenderId(input: SetDefaultSenderIdRequest): SetDefaultSenderIdResponse {
        val op = SdkHttpOperation.build<SetDefaultSenderIdRequest, SetDefaultSenderIdResponse> {
            serializer = SetDefaultSenderIdOperationSerializer()
            deserializer = SetDefaultSenderIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetDefaultSenderId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
     */
    override suspend fun setTextMessageSpendLimitOverride(input: SetTextMessageSpendLimitOverrideRequest): SetTextMessageSpendLimitOverrideResponse {
        val op = SdkHttpOperation.build<SetTextMessageSpendLimitOverrideRequest, SetTextMessageSpendLimitOverrideResponse> {
            serializer = SetTextMessageSpendLimitOverrideOperationSerializer()
            deserializer = SetTextMessageSpendLimitOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetTextMessageSpendLimitOverride"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
     */
    override suspend fun setVoiceMessageSpendLimitOverride(input: SetVoiceMessageSpendLimitOverrideRequest): SetVoiceMessageSpendLimitOverrideResponse {
        val op = SdkHttpOperation.build<SetVoiceMessageSpendLimitOverrideRequest, SetVoiceMessageSpendLimitOverrideResponse> {
            serializer = SetVoiceMessageSpendLimitOverrideOperationSerializer()
            deserializer = SetVoiceMessageSpendLimitOverrideOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetVoiceMessageSpendLimitOverride"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.
     *
     * You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.
     */
    override suspend fun updateEventDestination(input: UpdateEventDestinationRequest): UpdateEventDestinationResponse {
        val op = SdkHttpOperation.build<UpdateEventDestinationRequest, UpdateEventDestinationResponse> {
            serializer = UpdateEventDestinationOperationSerializer()
            deserializer = UpdateEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.
     *
     * If the origination phone number is associated with a pool, an Error is returned.
     */
    override suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse> {
            serializer = UpdatePhoneNumberOperationSerializer()
            deserializer = UpdatePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the `TwoWayChannelArn`, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.
     */
    override suspend fun updatePool(input: UpdatePoolRequest): UpdatePoolResponse {
        val op = SdkHttpOperation.build<UpdatePoolRequest, UpdatePoolResponse> {
            serializer = UpdatePoolOperationSerializer()
            deserializer = UpdatePoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("PinpointSMSVoiceV2", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sms-voice"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sms-voice")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
