// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.pinpointsmsvoicev2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.*
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateOptOutListRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreateOptOutListResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreatePoolRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreatePoolResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteEventDestinationResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteKeywordRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeletePoolRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeletePoolResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePoolsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePoolsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PutKeywordRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PutKeywordResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SendTextMessageRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SendTextMessageResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.TagResourceRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.TagResourceResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UntagResourceRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UntagResourceResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdateEventDestinationResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdatePoolRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.UpdatePoolResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Welcome to the *Amazon Pinpoint SMS and Voice, version 2 API Reference*. This guide provides information about Amazon Pinpoint SMS and Voice, version 2 API resources, including supported HTTP methods, parameters, and schemas.
 *
 * Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple messaging channels. The Amazon Pinpoint SMS and Voice, version 2 API provides programmatic access to options that are unique to the SMS and voice channels and supplements the resources provided by the Amazon Pinpoint API.
 *
 * If you're new to Amazon Pinpoint, it's also helpful to review the [ Amazon Pinpoint Developer Guide](https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html). The *Amazon Pinpoint Developer Guide* provides tutorials, code samples, and procedures that demonstrate how to use Amazon Pinpoint features programmatically and how to integrate Amazon Pinpoint functionality into mobile apps and other types of applications. The guide also provides key information, such as Amazon Pinpoint integration with other Amazon Web Services services, and the quotas that apply to use of the service.
 */
public interface PinpointSmsVoiceV2Client : SdkClient {

    override val serviceName: String
        get() = "Pinpoint SMS Voice V2"
    /**
     * PinpointSmsVoiceV2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): PinpointSmsVoiceV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultPinpointSmsVoiceV2Client(config)
        }

        public operator fun invoke(config: Config): PinpointSmsVoiceV2Client = DefaultPinpointSmsVoiceV2Client(config)

        /**
         * Construct a [PinpointSmsVoiceV2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): PinpointSmsVoiceV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultPinpointSmsVoiceV2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the specified origination identity with a pool.
     *
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
     *
     * If the origination identity configuration doesn't match the pool's configuration, an Error is returned.
     */
    public suspend fun associateOriginationIdentity(input: AssociateOriginationIdentityRequest): AssociateOriginationIdentityResponse

    /**
     * Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
     *
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     *
     * When you send a message, you can optionally specify a single configuration set.
     */
    public suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse

    /**
     * Creates a new event destination in a configuration set.
     *
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     *
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
     */
    public suspend fun createEventDestination(input: CreateEventDestinationRequest): CreateEventDestinationResponse

    /**
     * Creates a new opt-out list.
     *
     * If the opt-out list name already exists, an Error is returned.
     *
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see [ SMS opt out ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout) in the *Amazon Pinpoint User Guide*.
     */
    public suspend fun createOptOutList(input: CreateOptOutListRequest): CreateOptOutListResponse

    /**
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     *
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't inherited from the origination identity and defaults to false.
     *
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
     */
    public suspend fun createPool(input: CreatePoolRequest): CreatePoolResponse

    /**
     * Deletes an existing configuration set.
     *
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages.
     */
    public suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse

    /**
     * Deletes an existing default message type on a configuration set.
     *
     *  A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
     */
    public suspend fun deleteDefaultMessageType(input: DeleteDefaultMessageTypeRequest): DeleteDefaultMessageTypeResponse

    /**
     * Deletes an existing default sender ID on a configuration set.
     *
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.
     */
    public suspend fun deleteDefaultSenderId(input: DeleteDefaultSenderIdRequest): DeleteDefaultSenderIdResponse

    /**
     * Deletes an existing event destination.
     *
     * An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     */
    public suspend fun deleteEventDestination(input: DeleteEventDestinationRequest): DeleteEventDestinationResponse

    /**
     * Deletes an existing keyword from an origination phone number or pool.
     *
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     */
    public suspend fun deleteKeyword(input: DeleteKeywordRequest): DeleteKeywordResponse

    /**
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     *
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an Error is returned.
     */
    public suspend fun deleteOptOutList(input: DeleteOptOutListRequest): DeleteOptOutListResponse

    /**
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     *
     * Each destination phone number can only be deleted once every 30 days.
     *
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an Error is returned.
     */
    public suspend fun deleteOptedOutNumber(input: DeleteOptedOutNumberRequest): DeleteOptedOutNumberResponse

    /**
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     *
     * If the pool status isn't active or if deletion protection is enabled, an Error is returned.
     *
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     */
    public suspend fun deletePool(input: DeletePoolRequest): DeletePoolResponse

    /**
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public suspend fun deleteTextMessageSpendLimitOverride(input: DeleteTextMessageSpendLimitOverrideRequest = DeleteTextMessageSpendLimitOverrideRequest {}): DeleteTextMessageSpendLimitOverrideResponse

    /**
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the `EnforcedLimit` equal to the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see [Amazon Pinpoint quotas](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public suspend fun deleteVoiceMessageSpendLimitOverride(input: DeleteVoiceMessageSpendLimitOverrideRequest = DeleteVoiceMessageSpendLimitOverrideRequest {}): DeleteVoiceMessageSpendLimitOverrideResponse

    /**
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     *
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse.
     */
    public suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest {}): DescribeAccountAttributesResponse

    /**
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     *
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see [ Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest {}): DescribeAccountLimitsResponse

    /**
     * Describes the specified configuration sets or all in your account.
     *
     * If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don't specify configuration set names or filters, the output includes information for all configuration sets.
     *
     * If you specify a configuration set name that isn't valid, an error is returned.
     */
    public suspend fun describeConfigurationSets(input: DescribeConfigurationSetsRequest = DescribeConfigurationSetsRequest {}): DescribeConfigurationSetsResponse

    /**
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     *
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * If you specify a keyword that isn't valid, an Error is returned.
     */
    public suspend fun describeKeywords(input: DescribeKeywordsRequest): DescribeKeywordsResponse

    /**
     * Describes the specified opt-out list or all opt-out lists in your account.
     *
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the output includes information for all opt-out lists.
     *
     * If you specify an opt-out list name that isn't valid, an Error is returned.
     */
    public suspend fun describeOptOutLists(input: DescribeOptOutListsRequest = DescribeOptOutListsRequest {}): DescribeOptOutListsResponse

    /**
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     *
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.
     *
     * If you specify an opted out number that isn't valid, an Error is returned.
     */
    public suspend fun describeOptedOutNumbers(input: DescribeOptedOutNumbersRequest): DescribeOptedOutNumbersResponse

    /**
     * Describes the specified origination phone number, or all the phone numbers in your account.
     *
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     *
     * If you specify a phone number ID that isn't valid, an Error is returned.
     */
    public suspend fun describePhoneNumbers(input: DescribePhoneNumbersRequest = DescribePhoneNumbersRequest {}): DescribePhoneNumbersResponse

    /**
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     *
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs or filters, the output includes information for all pools.
     *
     * If you specify a pool ID that isn't valid, an Error is returned.
     *
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
     */
    public suspend fun describePools(input: DescribePoolsRequest = DescribePoolsRequest {}): DescribePoolsResponse

    /**
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     *
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't specify SenderIds or filters, the output includes information for all SenderIds.
     *
     * f you specify a sender ID that isn't valid, an Error is returned.
     */
    public suspend fun describeSenderIds(input: DescribeSenderIdsRequest = DescribeSenderIdsRequest {}): DescribeSenderIdsResponse

    /**
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     *
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see [ Requesting increases to your monthly SMS spending quota for Amazon Pinpoint ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html) in the *Amazon Pinpoint User Guide*.
     */
    public suspend fun describeSpendLimits(input: DescribeSpendLimitsRequest = DescribeSpendLimitsRequest {}): DescribeSpendLimitsResponse

    /**
     * Removes the specified origination identity from an existing pool.
     *
     * If the origination identity isn't associated with the specified pool, an Error is returned.
     */
    public suspend fun disassociateOriginationIdentity(input: DisassociateOriginationIdentityRequest): DisassociateOriginationIdentityResponse

    /**
     * Lists all associated origination identities in your pool.
     *
     * If you specify filters, the output includes information for only those origination identities that meet the filter criteria.
     */
    public suspend fun listPoolOriginationIdentities(input: ListPoolOriginationIdentitiesRequest): ListPoolOriginationIdentitiesResponse

    /**
     * List all tags associated with a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates a keyword configuration on an origination phone number or pool.
     *
     *  A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
     *
     * If you specify a keyword that isn't valid, an Error is returned.
     */
    public suspend fun putKeyword(input: PutKeywordRequest): PutKeywordResponse

    /**
     * Creates an opted out destination phone number in the opt-out list.
     *
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an Error is returned.
     */
    public suspend fun putOptedOutNumber(input: PutOptedOutNumberRequest): PutOptedOutNumberResponse

    /**
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.
     *
     * If the origination phone number has deletion protection enabled or is associated with a pool, an Error is returned.
     */
    public suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse

    /**
     * Request an origination phone number for use in your account. For more information on phone number request see [ Requesting a number ](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html) in the *Amazon Pinpoint User Guide*.
     */
    public suspend fun requestPhoneNumber(input: RequestPhoneNumberRequest): RequestPhoneNumberResponse

    /**
     * Creates a new text message and sends it to a recipient's phone number.
     *
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see [Message Parts per Second (MPS) limits](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html) in the *Amazon Pinpoint User Guide*.
     */
    public suspend fun sendTextMessage(input: SendTextMessageRequest): SendTextMessageResponse

    /**
     * Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses [Amazon Polly](http://aws.amazon.com/polly/) to convert a text script into a voice message.
     */
    public suspend fun sendVoiceMessage(input: SendVoiceMessageRequest): SendVoiceMessageResponse

    /**
     * Sets the default message type on a configuration set.
     *
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
     */
    public suspend fun setDefaultMessageType(input: SetDefaultMessageTypeRequest): SetDefaultMessageTypeResponse

    /**
     * Sets default sender ID on a configuration set.
     *
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.
     */
    public suspend fun setDefaultSenderId(input: SetDefaultSenderIdRequest): SetDefaultSenderIdResponse

    /**
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
     */
    public suspend fun setTextMessageSpendLimitOverride(input: SetTextMessageSpendLimitOverrideRequest): SetTextMessageSpendLimitOverrideResponse

    /**
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
     */
    public suspend fun setVoiceMessageSpendLimitOverride(input: SetVoiceMessageSpendLimitOverrideRequest): SetVoiceMessageSpendLimitOverrideResponse

    /**
     * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.
     *
     * You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.
     */
    public suspend fun updateEventDestination(input: UpdateEventDestinationRequest): UpdateEventDestinationResponse

    /**
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.
     *
     * If the origination phone number is associated with a pool, an Error is returned.
     */
    public suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the `TwoWayChannelArn`, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.
     */
    public suspend fun updatePool(input: UpdatePoolRequest): UpdatePoolResponse
}

/**
 * Associates the specified origination identity with a pool.
 *
 * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
 *
 * If the origination identity configuration doesn't match the pool's configuration, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.associateOriginationIdentity(crossinline block: AssociateOriginationIdentityRequest.Builder.() -> Unit): AssociateOriginationIdentityResponse = associateOriginationIdentity(AssociateOriginationIdentityRequest.Builder().apply(block).build())

/**
 * Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
 *
 * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
 *
 * When you send a message, you can optionally specify a single configuration set.
 */
public suspend inline fun PinpointSmsVoiceV2Client.createConfigurationSet(crossinline block: CreateConfigurationSetRequest.Builder.() -> Unit): CreateConfigurationSetResponse = createConfigurationSet(CreateConfigurationSetRequest.Builder().apply(block).build())

/**
 * Creates a new event destination in a configuration set.
 *
 * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
 *
 * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
 */
public suspend inline fun PinpointSmsVoiceV2Client.createEventDestination(crossinline block: CreateEventDestinationRequest.Builder.() -> Unit): CreateEventDestinationResponse = createEventDestination(CreateEventDestinationRequest.Builder().apply(block).build())

/**
 * Creates a new opt-out list.
 *
 * If the opt-out list name already exists, an Error is returned.
 *
 * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see [ SMS opt out ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout) in the *Amazon Pinpoint User Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.createOptOutList(crossinline block: CreateOptOutListRequest.Builder.() -> Unit): CreateOptOutListResponse = createOptOutList(CreateOptOutListRequest.Builder().apply(block).build())

/**
 * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
 *
 * The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't inherited from the origination identity and defaults to false.
 *
 * If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.
 */
public suspend inline fun PinpointSmsVoiceV2Client.createPool(crossinline block: CreatePoolRequest.Builder.() -> Unit): CreatePoolResponse = createPool(CreatePoolRequest.Builder().apply(block).build())

/**
 * Deletes an existing configuration set.
 *
 * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteConfigurationSet(crossinline block: DeleteConfigurationSetRequest.Builder.() -> Unit): DeleteConfigurationSetResponse = deleteConfigurationSet(DeleteConfigurationSetRequest.Builder().apply(block).build())

/**
 * Deletes an existing default message type on a configuration set.
 *
 *  A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteDefaultMessageType(crossinline block: DeleteDefaultMessageTypeRequest.Builder.() -> Unit): DeleteDefaultMessageTypeResponse = deleteDefaultMessageType(DeleteDefaultMessageTypeRequest.Builder().apply(block).build())

/**
 * Deletes an existing default sender ID on a configuration set.
 *
 * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteDefaultSenderId(crossinline block: DeleteDefaultSenderIdRequest.Builder.() -> Unit): DeleteDefaultSenderIdResponse = deleteDefaultSenderId(DeleteDefaultSenderIdRequest.Builder().apply(block).build())

/**
 * Deletes an existing event destination.
 *
 * An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteEventDestination(crossinline block: DeleteEventDestinationRequest.Builder.() -> Unit): DeleteEventDestinationResponse = deleteEventDestination(DeleteEventDestinationRequest.Builder().apply(block).build())

/**
 * Deletes an existing keyword from an origination phone number or pool.
 *
 * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
 *
 * Keywords "HELP" and "STOP" can't be deleted or modified.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteKeyword(crossinline block: DeleteKeywordRequest.Builder.() -> Unit): DeleteKeywordResponse = deleteKeyword(DeleteKeywordRequest.Builder().apply(block).build())

/**
 * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
 *
 * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteOptOutList(crossinline block: DeleteOptOutListRequest.Builder.() -> Unit): DeleteOptOutListResponse = deleteOptOutList(DeleteOptOutListRequest.Builder().apply(block).build())

/**
 * Deletes an existing opted out destination phone number from the specified opt-out list.
 *
 * Each destination phone number can only be deleted once every 30 days.
 *
 * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteOptedOutNumber(crossinline block: DeleteOptedOutNumberRequest.Builder.() -> Unit): DeleteOptedOutNumberResponse = deleteOptedOutNumber(DeleteOptedOutNumberRequest.Builder().apply(block).build())

/**
 * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
 *
 * If the pool status isn't active or if deletion protection is enabled, an Error is returned.
 *
 * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deletePool(crossinline block: DeletePoolRequest.Builder.() -> Unit): DeletePoolResponse = deletePool(DeletePoolRequest.Builder().apply(block).build())

/**
 * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the `EnforcedLimit` to equal the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see [Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteTextMessageSpendLimitOverride(crossinline block: DeleteTextMessageSpendLimitOverrideRequest.Builder.() -> Unit): DeleteTextMessageSpendLimitOverrideResponse = deleteTextMessageSpendLimitOverride(DeleteTextMessageSpendLimitOverrideRequest.Builder().apply(block).build())

/**
 * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the `EnforcedLimit` equal to the `MaxLimit`, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see [Amazon Pinpoint quotas](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.deleteVoiceMessageSpendLimitOverride(crossinline block: DeleteVoiceMessageSpendLimitOverrideRequest.Builder.() -> Unit): DeleteVoiceMessageSpendLimitOverrideResponse = deleteVoiceMessageSpendLimitOverride(DeleteVoiceMessageSpendLimitOverrideRequest.Builder().apply(block).build())

/**
 * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you're ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
 *
 * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeAccountAttributes(crossinline block: DescribeAccountAttributesRequest.Builder.() -> Unit): DescribeAccountAttributesResponse = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
 *
 * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see [ Amazon Pinpoint quotas ](https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html) in the *Amazon Pinpoint Developer Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Describes the specified configuration sets or all in your account.
 *
 * If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don't specify configuration set names or filters, the output includes information for all configuration sets.
 *
 * If you specify a configuration set name that isn't valid, an error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeConfigurationSets(crossinline block: DescribeConfigurationSetsRequest.Builder.() -> Unit): DescribeConfigurationSetsResponse = describeConfigurationSets(DescribeConfigurationSetsRequest.Builder().apply(block).build())

/**
 * Describes the specified keywords or all keywords on your origination phone number or pool.
 *
 * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
 *
 * If you specify a keyword that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeKeywords(crossinline block: DescribeKeywordsRequest.Builder.() -> Unit): DescribeKeywordsResponse = describeKeywords(DescribeKeywordsRequest.Builder().apply(block).build())

/**
 * Describes the specified opt-out list or all opt-out lists in your account.
 *
 * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the output includes information for all opt-out lists.
 *
 * If you specify an opt-out list name that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeOptOutLists(crossinline block: DescribeOptOutListsRequest.Builder.() -> Unit): DescribeOptOutListsResponse = describeOptOutLists(DescribeOptOutListsRequest.Builder().apply(block).build())

/**
 * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
 *
 * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.
 *
 * If you specify an opted out number that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeOptedOutNumbers(crossinline block: DescribeOptedOutNumbersRequest.Builder.() -> Unit): DescribeOptedOutNumbersResponse = describeOptedOutNumbers(DescribeOptedOutNumbersRequest.Builder().apply(block).build())

/**
 * Describes the specified origination phone number, or all the phone numbers in your account.
 *
 * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don't specify phone number IDs or filters, the output includes information for all phone numbers.
 *
 * If you specify a phone number ID that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describePhoneNumbers(crossinline block: DescribePhoneNumbersRequest.Builder.() -> Unit): DescribePhoneNumbersResponse = describePhoneNumbers(DescribePhoneNumbersRequest.Builder().apply(block).build())

/**
 * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
 *
 * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs or filters, the output includes information for all pools.
 *
 * If you specify a pool ID that isn't valid, an Error is returned.
 *
 * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describePools(crossinline block: DescribePoolsRequest.Builder.() -> Unit): DescribePoolsResponse = describePools(DescribePoolsRequest.Builder().apply(block).build())

/**
 * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
 *
 * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't specify SenderIds or filters, the output includes information for all SenderIds.
 *
 * f you specify a sender ID that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeSenderIds(crossinline block: DescribeSenderIdsRequest.Builder.() -> Unit): DescribeSenderIdsResponse = describeSenderIds(DescribeSenderIdsRequest.Builder().apply(block).build())

/**
 * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
 *
 * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see [ Requesting increases to your monthly SMS spending quota for Amazon Pinpoint ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html) in the *Amazon Pinpoint User Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.describeSpendLimits(crossinline block: DescribeSpendLimitsRequest.Builder.() -> Unit): DescribeSpendLimitsResponse = describeSpendLimits(DescribeSpendLimitsRequest.Builder().apply(block).build())

/**
 * Removes the specified origination identity from an existing pool.
 *
 * If the origination identity isn't associated with the specified pool, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.disassociateOriginationIdentity(crossinline block: DisassociateOriginationIdentityRequest.Builder.() -> Unit): DisassociateOriginationIdentityResponse = disassociateOriginationIdentity(DisassociateOriginationIdentityRequest.Builder().apply(block).build())

/**
 * Lists all associated origination identities in your pool.
 *
 * If you specify filters, the output includes information for only those origination identities that meet the filter criteria.
 */
public suspend inline fun PinpointSmsVoiceV2Client.listPoolOriginationIdentities(crossinline block: ListPoolOriginationIdentitiesRequest.Builder.() -> Unit): ListPoolOriginationIdentitiesResponse = listPoolOriginationIdentities(ListPoolOriginationIdentitiesRequest.Builder().apply(block).build())

/**
 * List all tags associated with a resource.
 */
public suspend inline fun PinpointSmsVoiceV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates a keyword configuration on an origination phone number or pool.
 *
 *  A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.
 *
 * If you specify a keyword that isn't valid, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.putKeyword(crossinline block: PutKeywordRequest.Builder.() -> Unit): PutKeywordResponse = putKeyword(PutKeywordRequest.Builder().apply(block).build())

/**
 * Creates an opted out destination phone number in the opt-out list.
 *
 * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.putOptedOutNumber(crossinline block: PutOptedOutNumberRequest.Builder.() -> Unit): PutOptedOutNumberResponse = putOptedOutNumber(PutOptedOutNumberRequest.Builder().apply(block).build())

/**
 * Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.
 *
 * If the origination phone number has deletion protection enabled or is associated with a pool, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.releasePhoneNumber(crossinline block: ReleasePhoneNumberRequest.Builder.() -> Unit): ReleasePhoneNumberResponse = releasePhoneNumber(ReleasePhoneNumberRequest.Builder().apply(block).build())

/**
 * Request an origination phone number for use in your account. For more information on phone number request see [ Requesting a number ](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html) in the *Amazon Pinpoint User Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.requestPhoneNumber(crossinline block: RequestPhoneNumberRequest.Builder.() -> Unit): RequestPhoneNumberResponse = requestPhoneNumber(RequestPhoneNumberRequest.Builder().apply(block).build())

/**
 * Creates a new text message and sends it to a recipient's phone number.
 *
 * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see [Message Parts per Second (MPS) limits](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html) in the *Amazon Pinpoint User Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.sendTextMessage(crossinline block: SendTextMessageRequest.Builder.() -> Unit): SendTextMessageResponse = sendTextMessage(SendTextMessageRequest.Builder().apply(block).build())

/**
 * Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses [Amazon Polly](http://aws.amazon.com/polly/) to convert a text script into a voice message.
 */
public suspend inline fun PinpointSmsVoiceV2Client.sendVoiceMessage(crossinline block: SendVoiceMessageRequest.Builder.() -> Unit): SendVoiceMessageResponse = sendVoiceMessage(SendVoiceMessageRequest.Builder().apply(block).build())

/**
 * Sets the default message type on a configuration set.
 *
 * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose **Transactional**. If you plan to send messages that contain marketing material or other promotional content, choose **Promotional**. This setting applies to your entire Amazon Web Services account.
 */
public suspend inline fun PinpointSmsVoiceV2Client.setDefaultMessageType(crossinline block: SetDefaultMessageTypeRequest.Builder.() -> Unit): SetDefaultMessageTypeResponse = setDefaultMessageType(SetDefaultMessageTypeRequest.Builder().apply(block).build())

/**
 * Sets default sender ID on a configuration set.
 *
 * When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.
 */
public suspend inline fun PinpointSmsVoiceV2Client.setDefaultSenderId(crossinline block: SetDefaultSenderIdRequest.Builder.() -> Unit): SetDefaultSenderIdResponse = setDefaultSenderId(SetDefaultSenderIdRequest.Builder().apply(block).build())

/**
 * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
 */
public suspend inline fun PinpointSmsVoiceV2Client.setTextMessageSpendLimitOverride(crossinline block: SetTextMessageSpendLimitOverrideRequest.Builder.() -> Unit): SetTextMessageSpendLimitOverrideResponse = setTextMessageSpendLimitOverride(SetTextMessageSpendLimitOverrideRequest.Builder().apply(block).build())

/**
 * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the `MaxLimit`, which is set by Amazon Web Services.
 */
public suspend inline fun PinpointSmsVoiceV2Client.setVoiceMessageSpendLimitOverride(crossinline block: SetVoiceMessageSpendLimitOverrideRequest.Builder.() -> Unit): SetVoiceMessageSpendLimitOverrideResponse = setVoiceMessageSpendLimitOverride(SetVoiceMessageSpendLimitOverrideRequest.Builder().apply(block).build())

/**
 * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see [ Tagging Amazon Pinpoint resources](https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html) in the *Amazon Pinpoint Developer Guide*.
 */
public suspend inline fun PinpointSmsVoiceV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.
 *
 * You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.
 */
public suspend inline fun PinpointSmsVoiceV2Client.updateEventDestination(crossinline block: UpdateEventDestinationRequest.Builder.() -> Unit): UpdateEventDestinationResponse = updateEventDestination(UpdateEventDestinationRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.
 *
 * If the origination phone number is associated with a pool, an Error is returned.
 */
public suspend inline fun PinpointSmsVoiceV2Client.updatePhoneNumber(crossinline block: UpdatePhoneNumberRequest.Builder.() -> Unit): UpdatePhoneNumberResponse = updatePhoneNumber(UpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the `TwoWayChannelArn`, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.
 */
public suspend inline fun PinpointSmsVoiceV2Client.updatePool(crossinline block: UpdatePoolRequest.Builder.() -> Unit): UpdatePoolResponse = updatePool(UpdatePoolRequest.Builder().apply(block).build())
