// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.model



/**
 * Contains information about an event destination.
 *
 * Event destinations are associated with configuration sets, which enable you to publish message sending events to Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS.
 */
public class EventDestination private constructor(builder: Builder) {
    /**
     * An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.
     */
    public val cloudWatchLogsDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination? = builder.cloudWatchLogsDestination
    /**
     * When set to true events will be logged.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The name of the EventDestination.
     */
    public val eventDestinationName: kotlin.String? = builder.eventDestinationName
    /**
     * An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.
     */
    public val kinesisFirehoseDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination? = builder.kinesisFirehoseDestination
    /**
     * An array of event types that determine which events to log.
     */
    public val matchingEventTypes: List<EventType>? = builder.matchingEventTypes
    /**
     * An object that contains information about an event destination that sends logging events to Amazon SNS.
     */
    public val snsDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SnsDestination? = builder.snsDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.EventDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDestination(")
        append("cloudWatchLogsDestination=$cloudWatchLogsDestination,")
        append("enabled=$enabled,")
        append("eventDestinationName=$eventDestinationName,")
        append("kinesisFirehoseDestination=$kinesisFirehoseDestination,")
        append("matchingEventTypes=$matchingEventTypes,")
        append("snsDestination=$snsDestination)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsDestination?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (eventDestinationName?.hashCode() ?: 0)
        result = 31 * result + (kinesisFirehoseDestination?.hashCode() ?: 0)
        result = 31 * result + (matchingEventTypes?.hashCode() ?: 0)
        result = 31 * result + (snsDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDestination

        if (cloudWatchLogsDestination != other.cloudWatchLogsDestination) return false
        if (enabled != other.enabled) return false
        if (eventDestinationName != other.eventDestinationName) return false
        if (kinesisFirehoseDestination != other.kinesisFirehoseDestination) return false
        if (matchingEventTypes != other.matchingEventTypes) return false
        if (snsDestination != other.snsDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.EventDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.
         */
        public var cloudWatchLogsDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination? = null
        /**
         * When set to true events will be logged.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The name of the EventDestination.
         */
        public var eventDestinationName: kotlin.String? = null
        /**
         * An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.
         */
        public var kinesisFirehoseDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination? = null
        /**
         * An array of event types that determine which events to log.
         */
        public var matchingEventTypes: List<EventType>? = null
        /**
         * An object that contains information about an event destination that sends logging events to Amazon SNS.
         */
        public var snsDestination: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SnsDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.EventDestination) : this() {
            this.cloudWatchLogsDestination = x.cloudWatchLogsDestination
            this.enabled = x.enabled
            this.eventDestinationName = x.eventDestinationName
            this.kinesisFirehoseDestination = x.kinesisFirehoseDestination
            this.matchingEventTypes = x.matchingEventTypes
            this.snsDestination = x.snsDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.EventDestination = EventDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination] inside the given [block]
         */
        public fun cloudWatchLogsDestination(block: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination.Builder.() -> kotlin.Unit) {
            this.cloudWatchLogsDestination = aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination] inside the given [block]
         */
        public fun kinesisFirehoseDestination(block: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseDestination = aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SnsDestination] inside the given [block]
         */
        public fun snsDestination(block: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SnsDestination.Builder.() -> kotlin.Unit) {
            this.snsDestination = aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SnsDestination.invoke(block)
        }
    }
}
