// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.model



/**
 * Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the Identity and Access Management (IAM) role associated with an Kinesis Data Firehose event destination.
 *
 * Event destinations, such as Kinesis Data Firehose, are associated with configuration sets, which enable you to publish message sending events.
 */
public class KinesisFirehoseDestination private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the delivery stream.
     */
    public val deliveryStreamArn: kotlin.String? = builder.deliveryStreamArn
    /**
     * The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisFirehoseDestination(")
        append("deliveryStreamArn=$deliveryStreamArn,")
        append("iamRoleArn=$iamRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStreamArn?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisFirehoseDestination

        if (deliveryStreamArn != other.deliveryStreamArn) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the delivery stream.
         */
        public var deliveryStreamArn: kotlin.String? = null
        /**
         * The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.
         */
        public var iamRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination) : this() {
            this.deliveryStreamArn = x.deliveryStreamArn
            this.iamRoleArn = x.iamRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination = KinesisFirehoseDestination(this)
    }
}
