// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The information for a phone number in an Amazon Web Services account.
 */
public class PhoneNumberInformation private constructor(builder: Builder) {
    /**
     * The time when the phone number was created, in [UNIX epoch time](https://www.epochconverter.com/) format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * When set to true the phone number can't be deleted.
     */
    public val deletionProtectionEnabled: kotlin.Boolean = builder.deletionProtectionEnabled
    /**
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public val isoCountryCode: kotlin.String? = builder.isoCountryCode
    /**
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.
     */
    public val messageType: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.MessageType? = builder.messageType
    /**
     * The price, in US dollars, to lease the phone number.
     */
    public val monthlyLeasingPrice: kotlin.String? = builder.monthlyLeasingPrice
    /**
     * Describes if the origination identity can be used for text messages, voice calls or both.
     */
    public val numberCapabilities: List<NumberCapability>? = builder.numberCapabilities
    /**
     * The type of phone number.
     */
    public val numberType: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberType? = builder.numberType
    /**
     * The name of the OptOutList associated with the phone number.
     */
    public val optOutListName: kotlin.String? = builder.optOutListName
    /**
     * The phone number in E.164 format.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The Amazon Resource Name (ARN) associated with the phone number.
     */
    public val phoneNumberArn: kotlin.String? = builder.phoneNumberArn
    /**
     * The unique identifier for the phone number.
     */
    public val phoneNumberId: kotlin.String? = builder.phoneNumberId
    /**
     * The unique identifier of the pool associated with the phone number.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see [Self-managed opt-outs](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out)
     */
    public val selfManagedOptOutsEnabled: kotlin.Boolean = builder.selfManagedOptOutsEnabled
    /**
     * The current status of the phone number.
     */
    public val status: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the two way channel.
     */
    public val twoWayChannelArn: kotlin.String? = builder.twoWayChannelArn
    /**
     * By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
     */
    public val twoWayEnabled: kotlin.Boolean = builder.twoWayEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PhoneNumberInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumberInformation(")
        append("createdTimestamp=$createdTimestamp,")
        append("deletionProtectionEnabled=$deletionProtectionEnabled,")
        append("isoCountryCode=$isoCountryCode,")
        append("messageType=$messageType,")
        append("monthlyLeasingPrice=$monthlyLeasingPrice,")
        append("numberCapabilities=$numberCapabilities,")
        append("numberType=$numberType,")
        append("optOutListName=$optOutListName,")
        append("phoneNumber=$phoneNumber,")
        append("phoneNumberArn=$phoneNumberArn,")
        append("phoneNumberId=$phoneNumberId,")
        append("poolId=$poolId,")
        append("selfManagedOptOutsEnabled=$selfManagedOptOutsEnabled,")
        append("status=$status,")
        append("twoWayChannelArn=$twoWayChannelArn,")
        append("twoWayEnabled=$twoWayEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (deletionProtectionEnabled.hashCode())
        result = 31 * result + (isoCountryCode?.hashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (monthlyLeasingPrice?.hashCode() ?: 0)
        result = 31 * result + (numberCapabilities?.hashCode() ?: 0)
        result = 31 * result + (numberType?.hashCode() ?: 0)
        result = 31 * result + (optOutListName?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberId?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (selfManagedOptOutsEnabled.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (twoWayChannelArn?.hashCode() ?: 0)
        result = 31 * result + (twoWayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhoneNumberInformation

        if (createdTimestamp != other.createdTimestamp) return false
        if (deletionProtectionEnabled != other.deletionProtectionEnabled) return false
        if (isoCountryCode != other.isoCountryCode) return false
        if (messageType != other.messageType) return false
        if (monthlyLeasingPrice != other.monthlyLeasingPrice) return false
        if (numberCapabilities != other.numberCapabilities) return false
        if (numberType != other.numberType) return false
        if (optOutListName != other.optOutListName) return false
        if (phoneNumber != other.phoneNumber) return false
        if (phoneNumberArn != other.phoneNumberArn) return false
        if (phoneNumberId != other.phoneNumberId) return false
        if (poolId != other.poolId) return false
        if (selfManagedOptOutsEnabled != other.selfManagedOptOutsEnabled) return false
        if (status != other.status) return false
        if (twoWayChannelArn != other.twoWayChannelArn) return false
        if (twoWayEnabled != other.twoWayEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PhoneNumberInformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the phone number was created, in [UNIX epoch time](https://www.epochconverter.com/) format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When set to true the phone number can't be deleted.
         */
        public var deletionProtectionEnabled: kotlin.Boolean = false
        /**
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         */
        public var isoCountryCode: kotlin.String? = null
        /**
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren't critical or time-sensitive.
         */
        public var messageType: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.MessageType? = null
        /**
         * The price, in US dollars, to lease the phone number.
         */
        public var monthlyLeasingPrice: kotlin.String? = null
        /**
         * Describes if the origination identity can be used for text messages, voice calls or both.
         */
        public var numberCapabilities: List<NumberCapability>? = null
        /**
         * The type of phone number.
         */
        public var numberType: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberType? = null
        /**
         * The name of the OptOutList associated with the phone number.
         */
        public var optOutListName: kotlin.String? = null
        /**
         * The phone number in E.164 format.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) associated with the phone number.
         */
        public var phoneNumberArn: kotlin.String? = null
        /**
         * The unique identifier for the phone number.
         */
        public var phoneNumberId: kotlin.String? = null
        /**
         * The unique identifier of the pool associated with the phone number.
         */
        public var poolId: kotlin.String? = null
        /**
         * When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see [Self-managed opt-outs](https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out)
         */
        public var selfManagedOptOutsEnabled: kotlin.Boolean = false
        /**
         * The current status of the phone number.
         */
        public var status: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the two way channel.
         */
        public var twoWayChannelArn: kotlin.String? = null
        /**
         * By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
         */
        public var twoWayEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PhoneNumberInformation) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.deletionProtectionEnabled = x.deletionProtectionEnabled
            this.isoCountryCode = x.isoCountryCode
            this.messageType = x.messageType
            this.monthlyLeasingPrice = x.monthlyLeasingPrice
            this.numberCapabilities = x.numberCapabilities
            this.numberType = x.numberType
            this.optOutListName = x.optOutListName
            this.phoneNumber = x.phoneNumber
            this.phoneNumberArn = x.phoneNumberArn
            this.phoneNumberId = x.phoneNumberId
            this.poolId = x.poolId
            this.selfManagedOptOutsEnabled = x.selfManagedOptOutsEnabled
            this.status = x.status
            this.twoWayChannelArn = x.twoWayChannelArn
            this.twoWayEnabled = x.twoWayEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PhoneNumberInformation = PhoneNumberInformation(this)
    }
}
