// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.model



/**
 * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages. For more information on increasing your monthly spend limit, see [ Requesting increases to your monthly SMS spending quota for Amazon Pinpoint ](https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html) in the *Amazon Pinpoint User Guide*.
 */
public class SpendLimit private constructor(builder: Builder) {
    /**
     * The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in `MaxLimit`. To use this custom limit, `Overridden` must be set to true.
     */
    public val enforcedLimit: kotlin.Long = builder.enforcedLimit
    /**
     * The maximum amount of money that you are able to spend to send messages each month, in US dollars.
     */
    public val maxLimit: kotlin.Long = builder.maxLimit
    /**
     * The name for the SpendLimit.
     */
    public val name: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimitName? = builder.name
    /**
     * When set to `True`, the value that has been specified in the `EnforcedLimit` is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.
     */
    public val overridden: kotlin.Boolean = builder.overridden

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpendLimit(")
        append("enforcedLimit=$enforcedLimit,")
        append("maxLimit=$maxLimit,")
        append("name=$name,")
        append("overridden=$overridden)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enforcedLimit.hashCode()
        result = 31 * result + (maxLimit.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overridden.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpendLimit

        if (enforcedLimit != other.enforcedLimit) return false
        if (maxLimit != other.maxLimit) return false
        if (name != other.name) return false
        if (overridden != other.overridden) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in `MaxLimit`. To use this custom limit, `Overridden` must be set to true.
         */
        public var enforcedLimit: kotlin.Long = 0L
        /**
         * The maximum amount of money that you are able to spend to send messages each month, in US dollars.
         */
        public var maxLimit: kotlin.Long = 0L
        /**
         * The name for the SpendLimit.
         */
        public var name: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimitName? = null
        /**
         * When set to `True`, the value that has been specified in the `EnforcedLimit` is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.
         */
        public var overridden: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimit) : this() {
            this.enforcedLimit = x.enforcedLimit
            this.maxLimit = x.maxLimit
            this.name = x.name
            this.overridden = x.overridden
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimit = SpendLimit(this)
    }
}
