// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.paginators

import aws.sdk.kotlin.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.AccountAttribute
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.AccountLimit
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ConfigurationSetInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePoolsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribePoolsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KeywordInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.OptOutListInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PhoneNumberInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PoolInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SenderIdInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.SpendLimit
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAccountAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccountAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountAttributesResponse]
 */
public fun PinpointSmsVoiceV2Client.describeAccountAttributesPaginated(initialRequest: DescribeAccountAttributesRequest): Flow<DescribeAccountAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccountAttributesPaginated.describeAccountAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccountAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountAttributesResponse]
 */
public fun PinpointSmsVoiceV2Client.describeAccountAttributesPaginated(block: DescribeAccountAttributesRequest.Builder.() -> Unit): Flow<DescribeAccountAttributesResponse> =
    describeAccountAttributesPaginated(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAccountAttributesPaginated]
 * to access the nested member [AccountAttribute]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAttribute]
 */
@JvmName("describeAccountAttributesResponseAccountAttribute")
public fun Flow<DescribeAccountAttributesResponse>.accountAttributes(): Flow<AccountAttribute> =
    transform() { response ->
        response.accountAttributes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccountLimitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeAccountLimitsPaginated(initialRequest: DescribeAccountLimitsRequest): Flow<DescribeAccountLimitsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccountLimitsPaginated.describeAccountLimits(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeAccountLimitsPaginated(block: DescribeAccountLimitsRequest.Builder.() -> Unit): Flow<DescribeAccountLimitsResponse> =
    describeAccountLimitsPaginated(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAccountLimitsPaginated]
 * to access the nested member [AccountLimit]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountLimit]
 */
@JvmName("describeAccountLimitsResponseAccountLimit")
public fun Flow<DescribeAccountLimitsResponse>.accountLimits(): Flow<AccountLimit> =
    transform() { response ->
        response.accountLimits?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeConfigurationSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConfigurationSetsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeConfigurationSetsPaginated(initialRequest: DescribeConfigurationSetsRequest): Flow<DescribeConfigurationSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeConfigurationSetsPaginated.describeConfigurationSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeConfigurationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConfigurationSetsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeConfigurationSetsPaginated(block: DescribeConfigurationSetsRequest.Builder.() -> Unit): Flow<DescribeConfigurationSetsResponse> =
    describeConfigurationSetsPaginated(DescribeConfigurationSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeConfigurationSetsPaginated]
 * to access the nested member [ConfigurationSetInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationSetInformation]
 */
@JvmName("describeConfigurationSetsResponseConfigurationSetInformation")
public fun Flow<DescribeConfigurationSetsResponse>.configurationSets(): Flow<ConfigurationSetInformation> =
    transform() { response ->
        response.configurationSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeKeywordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeKeywordsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeKeywordsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeKeywordsPaginated(initialRequest: DescribeKeywordsRequest): Flow<DescribeKeywordsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeKeywordsPaginated.describeKeywords(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeKeywordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeKeywordsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeKeywordsPaginated(block: DescribeKeywordsRequest.Builder.() -> Unit): Flow<DescribeKeywordsResponse> =
    describeKeywordsPaginated(DescribeKeywordsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeKeywordsPaginated]
 * to access the nested member [KeywordInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KeywordInformation]
 */
@JvmName("describeKeywordsResponseKeywordInformation")
public fun Flow<DescribeKeywordsResponse>.keywords(): Flow<KeywordInformation> =
    transform() { response ->
        response.keywords?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeOptedOutNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOptedOutNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOptedOutNumbersResponse]
 */
public fun PinpointSmsVoiceV2Client.describeOptedOutNumbersPaginated(initialRequest: DescribeOptedOutNumbersRequest): Flow<DescribeOptedOutNumbersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOptedOutNumbersPaginated.describeOptedOutNumbers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOptedOutNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOptedOutNumbersResponse]
 */
public fun PinpointSmsVoiceV2Client.describeOptedOutNumbersPaginated(block: DescribeOptedOutNumbersRequest.Builder.() -> Unit): Flow<DescribeOptedOutNumbersResponse> =
    describeOptedOutNumbersPaginated(DescribeOptedOutNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeOptedOutNumbersPaginated]
 * to access the nested member [OptedOutNumberInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OptedOutNumberInformation]
 */
@JvmName("describeOptedOutNumbersResponseOptedOutNumberInformation")
public fun Flow<DescribeOptedOutNumbersResponse>.optedOutNumbers(): Flow<OptedOutNumberInformation> =
    transform() { response ->
        response.optedOutNumbers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeOptOutListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOptOutListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOptOutListsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeOptOutListsPaginated(initialRequest: DescribeOptOutListsRequest): Flow<DescribeOptOutListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOptOutListsPaginated.describeOptOutLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOptOutListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOptOutListsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeOptOutListsPaginated(block: DescribeOptOutListsRequest.Builder.() -> Unit): Flow<DescribeOptOutListsResponse> =
    describeOptOutListsPaginated(DescribeOptOutListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeOptOutListsPaginated]
 * to access the nested member [OptOutListInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OptOutListInformation]
 */
@JvmName("describeOptOutListsResponseOptOutListInformation")
public fun Flow<DescribeOptOutListsResponse>.optOutLists(): Flow<OptOutListInformation> =
    transform() { response ->
        response.optOutLists?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePhoneNumbersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePhoneNumbersResponse]
 */
public fun PinpointSmsVoiceV2Client.describePhoneNumbersPaginated(initialRequest: DescribePhoneNumbersRequest): Flow<DescribePhoneNumbersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePhoneNumbersPaginated.describePhoneNumbers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePhoneNumbersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePhoneNumbersResponse]
 */
public fun PinpointSmsVoiceV2Client.describePhoneNumbersPaginated(block: DescribePhoneNumbersRequest.Builder.() -> Unit): Flow<DescribePhoneNumbersResponse> =
    describePhoneNumbersPaginated(DescribePhoneNumbersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePhoneNumbersPaginated]
 * to access the nested member [PhoneNumberInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PhoneNumberInformation]
 */
@JvmName("describePhoneNumbersResponsePhoneNumberInformation")
public fun Flow<DescribePhoneNumbersResponse>.phoneNumbers(): Flow<PhoneNumberInformation> =
    transform() { response ->
        response.phoneNumbers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoolsResponse]
 */
public fun PinpointSmsVoiceV2Client.describePoolsPaginated(initialRequest: DescribePoolsRequest): Flow<DescribePoolsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePoolsPaginated.describePools(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoolsResponse]
 */
public fun PinpointSmsVoiceV2Client.describePoolsPaginated(block: DescribePoolsRequest.Builder.() -> Unit): Flow<DescribePoolsResponse> =
    describePoolsPaginated(DescribePoolsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePoolsPaginated]
 * to access the nested member [PoolInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PoolInformation]
 */
@JvmName("describePoolsResponsePoolInformation")
public fun Flow<DescribePoolsResponse>.pools(): Flow<PoolInformation> =
    transform() { response ->
        response.pools?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSenderIdsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSenderIdsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSenderIdsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeSenderIdsPaginated(initialRequest: DescribeSenderIdsRequest): Flow<DescribeSenderIdsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSenderIdsPaginated.describeSenderIds(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSenderIdsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSenderIdsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeSenderIdsPaginated(block: DescribeSenderIdsRequest.Builder.() -> Unit): Flow<DescribeSenderIdsResponse> =
    describeSenderIdsPaginated(DescribeSenderIdsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSenderIdsPaginated]
 * to access the nested member [SenderIdInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SenderIdInformation]
 */
@JvmName("describeSenderIdsResponseSenderIdInformation")
public fun Flow<DescribeSenderIdsResponse>.senderIds(): Flow<SenderIdInformation> =
    transform() { response ->
        response.senderIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSpendLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSpendLimitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSpendLimitsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeSpendLimitsPaginated(initialRequest: DescribeSpendLimitsRequest): Flow<DescribeSpendLimitsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSpendLimitsPaginated.describeSpendLimits(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSpendLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSpendLimitsResponse]
 */
public fun PinpointSmsVoiceV2Client.describeSpendLimitsPaginated(block: DescribeSpendLimitsRequest.Builder.() -> Unit): Flow<DescribeSpendLimitsResponse> =
    describeSpendLimitsPaginated(DescribeSpendLimitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSpendLimitsPaginated]
 * to access the nested member [SpendLimit]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SpendLimit]
 */
@JvmName("describeSpendLimitsResponseSpendLimit")
public fun Flow<DescribeSpendLimitsResponse>.spendLimits(): Flow<SpendLimit> =
    transform() { response ->
        response.spendLimits?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPoolOriginationIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoolOriginationIdentitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoolOriginationIdentitiesResponse]
 */
public fun PinpointSmsVoiceV2Client.listPoolOriginationIdentitiesPaginated(initialRequest: ListPoolOriginationIdentitiesRequest): Flow<ListPoolOriginationIdentitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPoolOriginationIdentitiesPaginated.listPoolOriginationIdentities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPoolOriginationIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoolOriginationIdentitiesResponse]
 */
public fun PinpointSmsVoiceV2Client.listPoolOriginationIdentitiesPaginated(block: ListPoolOriginationIdentitiesRequest.Builder.() -> Unit): Flow<ListPoolOriginationIdentitiesResponse> =
    listPoolOriginationIdentitiesPaginated(ListPoolOriginationIdentitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPoolOriginationIdentitiesPaginated]
 * to access the nested member [OriginationIdentityMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OriginationIdentityMetadata]
 */
@JvmName("listPoolOriginationIdentitiesResponseOriginationIdentityMetadata")
public fun Flow<ListPoolOriginationIdentitiesResponse>.originationIdentities(): Flow<OriginationIdentityMetadata> =
    transform() { response ->
        response.originationIdentities?.forEach {
            emit(it)
        }
    }
