// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.CreatePoolResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.MessageType
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PoolStatus
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreatePoolOperationDeserializer: HttpDeserialize<CreatePoolResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePoolResponse {
        if (!response.status.isSuccess()) {
            throwCreatePoolError(context, response)
        }
        val builder = CreatePoolResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePoolOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePoolError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePoolOperationBody(builder: CreatePoolResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DELETIONPROTECTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DeletionProtectionEnabled"))
    val MESSAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageType"))
    val OPTOUTLISTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListName"))
    val POOLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolArn"))
    val POOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolId"))
    val SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SelfManagedOptOutsEnabled"))
    val SHAREDROUTESENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SharedRoutesEnabled"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TWOWAYCHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TwoWayChannelArn"))
    val TWOWAYENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TwoWayEnabled"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DELETIONPROTECTIONENABLED_DESCRIPTOR)
        field(MESSAGETYPE_DESCRIPTOR)
        field(OPTOUTLISTNAME_DESCRIPTOR)
        field(POOLARN_DESCRIPTOR)
        field(POOLID_DESCRIPTOR)
        field(SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR)
        field(SHAREDROUTESENABLED_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TWOWAYCHANNELARN_DESCRIPTOR)
        field(TWOWAYENABLED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DELETIONPROTECTIONENABLED_DESCRIPTOR.index -> builder.deletionProtectionEnabled = deserializeBoolean()
                MESSAGETYPE_DESCRIPTOR.index -> builder.messageType = deserializeString().let { MessageType.fromValue(it) }
                OPTOUTLISTNAME_DESCRIPTOR.index -> builder.optOutListName = deserializeString()
                POOLARN_DESCRIPTOR.index -> builder.poolArn = deserializeString()
                POOLID_DESCRIPTOR.index -> builder.poolId = deserializeString()
                SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR.index -> builder.selfManagedOptOutsEnabled = deserializeBoolean()
                SHAREDROUTESENABLED_DESCRIPTOR.index -> builder.sharedRoutesEnabled = deserializeBoolean()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { PoolStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TWOWAYCHANNELARN_DESCRIPTOR.index -> builder.twoWayChannelArn = deserializeString()
                TWOWAYENABLED_DESCRIPTOR.index -> builder.twoWayEnabled = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
