// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KeywordAction
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteKeywordOperationDeserializer: HttpDeserialize<DeleteKeywordResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteKeywordResponse {
        if (!response.status.isSuccess()) {
            throwDeleteKeywordError(context, response)
        }
        val builder = DeleteKeywordResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteKeywordOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteKeywordError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteKeywordOperationBody(builder: DeleteKeywordResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Keyword"))
    val KEYWORDACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeywordAction"))
    val KEYWORDMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeywordMessage"))
    val ORIGINATIONIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentity"))
    val ORIGINATIONIDENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentityArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYWORD_DESCRIPTOR)
        field(KEYWORDACTION_DESCRIPTOR)
        field(KEYWORDMESSAGE_DESCRIPTOR)
        field(ORIGINATIONIDENTITY_DESCRIPTOR)
        field(ORIGINATIONIDENTITYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYWORD_DESCRIPTOR.index -> builder.keyword = deserializeString()
                KEYWORDACTION_DESCRIPTOR.index -> builder.keywordAction = deserializeString().let { KeywordAction.fromValue(it) }
                KEYWORDMESSAGE_DESCRIPTOR.index -> builder.keywordMessage = deserializeString()
                ORIGINATIONIDENTITY_DESCRIPTOR.index -> builder.originationIdentity = deserializeString()
                ORIGINATIONIDENTITYARN_DESCRIPTOR.index -> builder.originationIdentityArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
