// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DeleteOptedOutNumberOperationDeserializer: HttpDeserialize<DeleteOptedOutNumberResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteOptedOutNumberResponse {
        if (!response.status.isSuccess()) {
            throwDeleteOptedOutNumberError(context, response)
        }
        val builder = DeleteOptedOutNumberResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteOptedOutNumberOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteOptedOutNumberError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteOptedOutNumberOperationBody(builder: DeleteOptedOutNumberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDUSEROPTEDOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EndUserOptedOut"))
    val OPTOUTLISTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListArn"))
    val OPTOUTLISTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListName"))
    val OPTEDOUTNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptedOutNumber"))
    val OPTEDOUTTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("OptedOutTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDUSEROPTEDOUT_DESCRIPTOR)
        field(OPTOUTLISTARN_DESCRIPTOR)
        field(OPTOUTLISTNAME_DESCRIPTOR)
        field(OPTEDOUTNUMBER_DESCRIPTOR)
        field(OPTEDOUTTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDUSEROPTEDOUT_DESCRIPTOR.index -> builder.endUserOptedOut = deserializeBoolean()
                OPTOUTLISTARN_DESCRIPTOR.index -> builder.optOutListArn = deserializeString()
                OPTOUTLISTNAME_DESCRIPTOR.index -> builder.optOutListName = deserializeString()
                OPTEDOUTNUMBER_DESCRIPTOR.index -> builder.optedOutNumber = deserializeString()
                OPTEDOUTTIMESTAMP_DESCRIPTOR.index -> builder.optedOutTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
