// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.KeywordInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeKeywordsOperationDeserializer: HttpDeserialize<DescribeKeywordsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeKeywordsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeKeywordsError(context, response)
        }
        val builder = DescribeKeywordsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeKeywordsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeKeywordsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeKeywordsOperationBody(builder: DescribeKeywordsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYWORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Keywords"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val ORIGINATIONIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentity"))
    val ORIGINATIONIDENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentityArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYWORDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(ORIGINATIONIDENTITY_DESCRIPTOR)
        field(ORIGINATIONIDENTITYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYWORDS_DESCRIPTOR.index -> builder.keywords =
                    deserializer.deserializeList(KEYWORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<KeywordInformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKeywordInformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                ORIGINATIONIDENTITY_DESCRIPTOR.index -> builder.originationIdentity = deserializeString()
                ORIGINATIONIDENTITYARN_DESCRIPTOR.index -> builder.originationIdentityArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
