// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeOptedOutNumbersOperationDeserializer: HttpDeserialize<DescribeOptedOutNumbersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOptedOutNumbersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOptedOutNumbersError(context, response)
        }
        val builder = DescribeOptedOutNumbersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOptedOutNumbersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOptedOutNumbersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOptedOutNumbersOperationBody(builder: DescribeOptedOutNumbersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OPTOUTLISTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListArn"))
    val OPTOUTLISTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListName"))
    val OPTEDOUTNUMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OptedOutNumbers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(OPTOUTLISTARN_DESCRIPTOR)
        field(OPTOUTLISTNAME_DESCRIPTOR)
        field(OPTEDOUTNUMBERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                OPTOUTLISTARN_DESCRIPTOR.index -> builder.optOutListArn = deserializeString()
                OPTOUTLISTNAME_DESCRIPTOR.index -> builder.optOutListName = deserializeString()
                OPTEDOUTNUMBERS_DESCRIPTOR.index -> builder.optedOutNumbers =
                    deserializer.deserializeList(OPTEDOUTNUMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<OptedOutNumberInformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOptedOutNumberInformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
