// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DisassociateOriginationIdentityOperationDeserializer: HttpDeserialize<DisassociateOriginationIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisassociateOriginationIdentityResponse {
        if (!response.status.isSuccess()) {
            throwDisassociateOriginationIdentityError(context, response)
        }
        val builder = DisassociateOriginationIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisassociateOriginationIdentityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisassociateOriginationIdentityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisassociateOriginationIdentityOperationBody(builder: DisassociateOriginationIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ISOCOUNTRYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IsoCountryCode"))
    val ORIGINATIONIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentity"))
    val ORIGINATIONIDENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginationIdentityArn"))
    val POOLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolArn"))
    val POOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ISOCOUNTRYCODE_DESCRIPTOR)
        field(ORIGINATIONIDENTITY_DESCRIPTOR)
        field(ORIGINATIONIDENTITYARN_DESCRIPTOR)
        field(POOLARN_DESCRIPTOR)
        field(POOLID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISOCOUNTRYCODE_DESCRIPTOR.index -> builder.isoCountryCode = deserializeString()
                ORIGINATIONIDENTITY_DESCRIPTOR.index -> builder.originationIdentity = deserializeString()
                ORIGINATIONIDENTITYARN_DESCRIPTOR.index -> builder.originationIdentityArn = deserializeString()
                POOLARN_DESCRIPTOR.index -> builder.poolArn = deserializeString()
                POOLID_DESCRIPTOR.index -> builder.poolId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
