// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListPoolOriginationIdentitiesOperationDeserializer: HttpDeserialize<ListPoolOriginationIdentitiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListPoolOriginationIdentitiesResponse {
        if (!response.status.isSuccess()) {
            throwListPoolOriginationIdentitiesError(context, response)
        }
        val builder = ListPoolOriginationIdentitiesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPoolOriginationIdentitiesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListPoolOriginationIdentitiesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPoolOriginationIdentitiesOperationBody(builder: ListPoolOriginationIdentitiesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val ORIGINATIONIDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OriginationIdentities"))
    val POOLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolArn"))
    val POOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(ORIGINATIONIDENTITIES_DESCRIPTOR)
        field(POOLARN_DESCRIPTOR)
        field(POOLID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                ORIGINATIONIDENTITIES_DESCRIPTOR.index -> builder.originationIdentities =
                    deserializer.deserializeList(ORIGINATIONIDENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<OriginationIdentityMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOriginationIdentityMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POOLARN_DESCRIPTOR.index -> builder.poolArn = deserializeString()
                POOLID_DESCRIPTOR.index -> builder.poolId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
