// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pinpointsmsvoicev2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.MessageType
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberCapability
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.NumberStatus
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.RequestableNumberType
import aws.sdk.kotlin.services.pinpointsmsvoicev2.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class RequestPhoneNumberOperationDeserializer: HttpDeserialize<RequestPhoneNumberResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RequestPhoneNumberResponse {
        if (!response.status.isSuccess()) {
            throwRequestPhoneNumberError(context, response)
        }
        val builder = RequestPhoneNumberResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRequestPhoneNumberOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRequestPhoneNumberError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw PinpointSmsVoiceV2Exception("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> PinpointSmsVoiceV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRequestPhoneNumberOperationBody(builder: RequestPhoneNumberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DELETIONPROTECTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DeletionProtectionEnabled"))
    val ISOCOUNTRYCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IsoCountryCode"))
    val MESSAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageType"))
    val MONTHLYLEASINGPRICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonthlyLeasingPrice"))
    val NUMBERCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NumberCapabilities"))
    val NUMBERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NumberType"))
    val OPTOUTLISTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptOutListName"))
    val PHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumber"))
    val PHONENUMBERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumberArn"))
    val PHONENUMBERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumberId"))
    val POOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PoolId"))
    val SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SelfManagedOptOutsEnabled"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TWOWAYCHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TwoWayChannelArn"))
    val TWOWAYENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TwoWayEnabled"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DELETIONPROTECTIONENABLED_DESCRIPTOR)
        field(ISOCOUNTRYCODE_DESCRIPTOR)
        field(MESSAGETYPE_DESCRIPTOR)
        field(MONTHLYLEASINGPRICE_DESCRIPTOR)
        field(NUMBERCAPABILITIES_DESCRIPTOR)
        field(NUMBERTYPE_DESCRIPTOR)
        field(OPTOUTLISTNAME_DESCRIPTOR)
        field(PHONENUMBER_DESCRIPTOR)
        field(PHONENUMBERARN_DESCRIPTOR)
        field(PHONENUMBERID_DESCRIPTOR)
        field(POOLID_DESCRIPTOR)
        field(SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TWOWAYCHANNELARN_DESCRIPTOR)
        field(TWOWAYENABLED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DELETIONPROTECTIONENABLED_DESCRIPTOR.index -> builder.deletionProtectionEnabled = deserializeBoolean()
                ISOCOUNTRYCODE_DESCRIPTOR.index -> builder.isoCountryCode = deserializeString()
                MESSAGETYPE_DESCRIPTOR.index -> builder.messageType = deserializeString().let { MessageType.fromValue(it) }
                MONTHLYLEASINGPRICE_DESCRIPTOR.index -> builder.monthlyLeasingPrice = deserializeString()
                NUMBERCAPABILITIES_DESCRIPTOR.index -> builder.numberCapabilities =
                    deserializer.deserializeList(NUMBERCAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<NumberCapability>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { NumberCapability.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NUMBERTYPE_DESCRIPTOR.index -> builder.numberType = deserializeString().let { RequestableNumberType.fromValue(it) }
                OPTOUTLISTNAME_DESCRIPTOR.index -> builder.optOutListName = deserializeString()
                PHONENUMBER_DESCRIPTOR.index -> builder.phoneNumber = deserializeString()
                PHONENUMBERARN_DESCRIPTOR.index -> builder.phoneNumberArn = deserializeString()
                PHONENUMBERID_DESCRIPTOR.index -> builder.phoneNumberId = deserializeString()
                POOLID_DESCRIPTOR.index -> builder.poolId = deserializeString()
                SELFMANAGEDOPTOUTSENABLED_DESCRIPTOR.index -> builder.selfManagedOptOutsEnabled = deserializeBoolean()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { NumberStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TWOWAYCHANNELARN_DESCRIPTOR.index -> builder.twoWayChannelArn = deserializeString()
                TWOWAYENABLED_DESCRIPTOR.index -> builder.twoWayEnabled = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
