// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.model



/**
 * The constraints that you want all returned products to match.
 */
class Filter private constructor(builder: Builder) {
    /**
     * The product metadata field that you want to filter on. You can filter by just the service code to see all products for a specific service, filter by just the attribute name to see a specific attribute for multiple services, or use both a service code and an attribute name to retrieve only products that match both fields.
     *
     * Valid values include: `ServiceCode`, and all attribute names
     *
     * For example, you can filter by the `AmazonEC2` service code and the `volumeType` attribute name to get the prices for only Amazon EC2 volumes.
     */
    val field: kotlin.String? = builder.field
    /**
     * The type of filter that you want to use.
     *
     * Valid values are: `TERM_MATCH`. `TERM_MATCH` returns only products that match both the given filter field and the given value.
     */
    val type: aws.sdk.kotlin.services.pricing.model.FilterType? = builder.type
    /**
     * The service code or attribute value that you want to filter by. If you are filtering by service code this is the actual service code, such as `AmazonEC2`. If you are filtering by attribute name, this is the attribute value that you want the returned products to match, such as a `Provisioned IOPS` volume.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.pricing.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("field=$field,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (field != other.field) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.pricing.model.Filter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The product metadata field that you want to filter on. You can filter by just the service code to see all products for a specific service, filter by just the attribute name to see a specific attribute for multiple services, or use both a service code and an attribute name to retrieve only products that match both fields.
         *
         * Valid values include: `ServiceCode`, and all attribute names
         *
         * For example, you can filter by the `AmazonEC2` service code and the `volumeType` attribute name to get the prices for only Amazon EC2 volumes.
         */
        var field: kotlin.String? = null
        /**
         * The type of filter that you want to use.
         *
         * Valid values are: `TERM_MATCH`. `TERM_MATCH` returns only products that match both the given filter field and the given value.
         */
        var type: aws.sdk.kotlin.services.pricing.model.FilterType? = null
        /**
         * The service code or attribute value that you want to filter by. If you are filtering by service code this is the actual service code, such as `AmazonEC2`. If you are filtering by attribute name, this is the attribute value that you want the returned products to match, such as a `Provisioned IOPS` volume.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.pricing.model.Filter) : this() {
            this.field = x.field
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.pricing.model.Filter = Filter(this)
    }
}
