// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.pricing.paginators

import aws.sdk.kotlin.services.pricing.PricingClient
import aws.sdk.kotlin.services.pricing.model.DescribeServicesRequest
import aws.sdk.kotlin.services.pricing.model.DescribeServicesResponse
import aws.sdk.kotlin.services.pricing.model.GetAttributeValuesRequest
import aws.sdk.kotlin.services.pricing.model.GetAttributeValuesResponse
import aws.sdk.kotlin.services.pricing.model.GetProductsRequest
import aws.sdk.kotlin.services.pricing.model.GetProductsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServicesResponse]
 */
fun PricingClient.describeServicesPaginated(initialRequest: DescribeServicesRequest): Flow<DescribeServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServicesPaginated.describeServices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServicesResponse]
 */
fun PricingClient.describeServicesPaginated(block: DescribeServicesRequest.Builder.() -> Unit): Flow<DescribeServicesResponse> =
    describeServicesPaginated(DescribeServicesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetAttributeValuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetAttributeValuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAttributeValuesResponse]
 */
fun PricingClient.getAttributeValuesPaginated(initialRequest: GetAttributeValuesRequest): Flow<GetAttributeValuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getAttributeValuesPaginated.getAttributeValues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetAttributeValuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetAttributeValuesResponse]
 */
fun PricingClient.getAttributeValuesPaginated(block: GetAttributeValuesRequest.Builder.() -> Unit): Flow<GetAttributeValuesResponse> =
    getAttributeValuesPaginated(GetAttributeValuesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProductsResponse]
 */
fun PricingClient.getProductsPaginated(initialRequest: GetProductsRequest): Flow<GetProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getProductsPaginated.getProducts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProductsResponse]
 */
fun PricingClient.getProductsPaginated(block: GetProductsRequest.Builder.() -> Unit): Flow<GetProductsResponse> =
    getProductsPaginated(GetProductsRequest.Builder().apply(block).build())
