// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.proton.model.*
import aws.sdk.kotlin.services.proton.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Proton"
public const val ServiceApiVersion: String = "2020-07-20"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultProtonClient(override val config: ProtonClient.Config) : ProtonClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun acceptEnvironmentAccountConnection(input: AcceptEnvironmentAccountConnectionRequest): AcceptEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<AcceptEnvironmentAccountConnectionRequest, AcceptEnvironmentAccountConnectionResponse> {
            serializer = AcceptEnvironmentAccountConnectionOperationSerializer()
            deserializer = AcceptEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel a component deployment (for a component that is in the `IN_PROGRESS` deployment status).
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun cancelComponentDeployment(input: CancelComponentDeploymentRequest): CancelComponentDeploymentResponse {
        val op = SdkHttpOperation.build<CancelComponentDeploymentRequest, CancelComponentDeploymentResponse> {
            serializer = CancelComponentDeploymentOperationSerializer()
            deserializer = CancelComponentDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelComponentDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel an environment deployment on an UpdateEnvironment action, if the deployment is `IN_PROGRESS`. For more information, see [Update an environment](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-update.html) in the *Proton Administrator guide*.
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateEnvironment action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    override suspend fun cancelEnvironmentDeployment(input: CancelEnvironmentDeploymentRequest): CancelEnvironmentDeploymentResponse {
        val op = SdkHttpOperation.build<CancelEnvironmentDeploymentRequest, CancelEnvironmentDeploymentResponse> {
            serializer = CancelEnvironmentDeploymentOperationSerializer()
            deserializer = CancelEnvironmentDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelEnvironmentDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel a service instance deployment on an UpdateServiceInstance action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service instance* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-instance-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-instance-update.html).
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateServiceInstance action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    override suspend fun cancelServiceInstanceDeployment(input: CancelServiceInstanceDeploymentRequest): CancelServiceInstanceDeploymentResponse {
        val op = SdkHttpOperation.build<CancelServiceInstanceDeploymentRequest, CancelServiceInstanceDeploymentResponse> {
            serializer = CancelServiceInstanceDeploymentOperationSerializer()
            deserializer = CancelServiceInstanceDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelServiceInstanceDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel a service pipeline deployment on an UpdateServicePipeline action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service pipeline* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-pipeline-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-pipeline-update.html).
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateServicePipeline action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    override suspend fun cancelServicePipelineDeployment(input: CancelServicePipelineDeploymentRequest): CancelServicePipelineDeploymentResponse {
        val op = SdkHttpOperation.build<CancelServicePipelineDeploymentRequest, CancelServicePipelineDeploymentResponse> {
            serializer = CancelServicePipelineDeploymentOperationSerializer()
            deserializer = CancelServicePipelineDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelServicePipelineDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an Proton component. A component is an infrastructure extension for a service instance.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse {
        val op = SdkHttpOperation.build<CreateComponentRequest, CreateComponentResponse> {
            serializer = CreateComponentOperationSerializer()
            deserializer = CreateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.
     *
     * **You can provision environments using the following methods:**
     * + Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.
     * + Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as code (IaC) files that your IaC engine uses to provision resources.
     *
     * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentRequest, CreateEnvironmentResponse> {
            serializer = CreateEnvironmentOperationSerializer()
            deserializer = CreateEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.
     *
     * An environment account connection is a secure bi-directional connection between a *management account* and an *environment account* that maintains authorization and permissions. For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun createEnvironmentAccountConnection(input: CreateEnvironmentAccountConnectionRequest): CreateEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentAccountConnectionRequest, CreateEnvironmentAccountConnectionResponse> {
            serializer = CreateEnvironmentAccountConnectionOperationSerializer()
            deserializer = CreateEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an environment template for Proton. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the *Proton Administrator Guide*.
     *
     * You can create an environment template in one of the two following ways:
     * + Register and publish a *standard* environment template that instructs Proton to deploy and manage environment infrastructure.
     * + Register and publish a *customer managed* environment template that connects Proton to your existing provisioned infrastructure that you manage. Proton *doesn't* manage your existing provisioned infrastructure. To create an environment template for customer provisioned and managed infrastructure, include the `provisioning` parameter and set the value to `CUSTOMER_MANAGED`. For more information, see [Register and publish an environment template](https://docs.aws.amazon.com/proton/latest/adminguide/template-create.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createEnvironmentTemplate(input: CreateEnvironmentTemplateRequest): CreateEnvironmentTemplateResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentTemplateRequest, CreateEnvironmentTemplateResponse> {
            serializer = CreateEnvironmentTemplateOperationSerializer()
            deserializer = CreateEnvironmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEnvironmentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new major or minor version of an environment template. A major version of an environment template is a version that *isn't* backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.
     */
    override suspend fun createEnvironmentTemplateVersion(input: CreateEnvironmentTemplateVersionRequest): CreateEnvironmentTemplateVersionResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentTemplateVersionRequest, CreateEnvironmentTemplateVersionResponse> {
            serializer = CreateEnvironmentTemplateVersionOperationSerializer()
            deserializer = CreateEnvironmentTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEnvironmentTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create and register a link to a repository that can be used with self-managed provisioning (infrastructure or pipelines) or for template sync configurations. When you create a repository link, Proton creates a [service-linked role](https://docs.aws.amazon.com/proton/latest/adminguide/using-service-linked-roles.html) for you.
     *
     * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self), [Template bundles](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html), and [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse {
        val op = SdkHttpOperation.build<CreateRepositoryRequest, CreateRepositoryResponse> {
            serializer = CreateRepositoryOperationSerializer()
            deserializer = CreateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see [Services](https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html) in the *Proton Administrator Guide* and [Services](https://docs.aws.amazon.com/proton/latest/userguide/ug-service.html) in the *Proton User Guide*.
     */
    override suspend fun createService(input: CreateServiceRequest): CreateServiceResponse {
        val op = SdkHttpOperation.build<CreateServiceRequest, CreateServiceResponse> {
            serializer = CreateServiceOperationSerializer()
            deserializer = CreateServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see [Service Templates](https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createServiceTemplate(input: CreateServiceTemplateRequest): CreateServiceTemplateResponse {
        val op = SdkHttpOperation.build<CreateServiceTemplateRequest, CreateServiceTemplateResponse> {
            serializer = CreateServiceTemplateOperationSerializer()
            deserializer = CreateServiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateServiceTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new major or minor version of a service template. A major version of a service template is a version that *isn't* backward compatible. A minor version of a service template is a version that's backward compatible within its major version.
     */
    override suspend fun createServiceTemplateVersion(input: CreateServiceTemplateVersionRequest): CreateServiceTemplateVersionResponse {
        val op = SdkHttpOperation.build<CreateServiceTemplateVersionRequest, CreateServiceTemplateVersionResponse> {
            serializer = CreateServiceTemplateVersionOperationSerializer()
            deserializer = CreateServiceTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateServiceTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Set up a template to create new template versions automatically. When a commit is pushed to your registered [repository](https://docs.aws.amazon.com/proton/latest/APIReference/API_Repository.html), Proton checks for changes to your repository template bundles. If it detects a template bundle change, a new major or minor version of its template is created, if the version doesn’t already exist. For more information, see [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
     */
    override suspend fun createTemplateSyncConfig(input: CreateTemplateSyncConfigRequest): CreateTemplateSyncConfigResponse {
        val op = SdkHttpOperation.build<CreateTemplateSyncConfigRequest, CreateTemplateSyncConfigResponse> {
            serializer = CreateTemplateSyncConfigOperationSerializer()
            deserializer = CreateTemplateSyncConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTemplateSyncConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an Proton component resource.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an environment.
     */
    override suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentRequest, DeleteEnvironmentResponse> {
            serializer = DeleteEnvironmentOperationSerializer()
            deserializer = DeleteEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * In an environment account, delete an environment account connection.
     *
     * After you delete an environment account connection that’s in use by an Proton environment, Proton *can’t* manage the environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment. You're responsible for cleaning up provisioned resources that remain without an environment connection.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun deleteEnvironmentAccountConnection(input: DeleteEnvironmentAccountConnectionRequest): DeleteEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentAccountConnectionRequest, DeleteEnvironmentAccountConnectionResponse> {
            serializer = DeleteEnvironmentAccountConnectionOperationSerializer()
            deserializer = DeleteEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If no other major or minor versions of an environment template exist, delete the environment template.
     */
    override suspend fun deleteEnvironmentTemplate(input: DeleteEnvironmentTemplateRequest): DeleteEnvironmentTemplateResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentTemplateRequest, DeleteEnvironmentTemplateResponse> {
            serializer = DeleteEnvironmentTemplateOperationSerializer()
            deserializer = DeleteEnvironmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEnvironmentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the `Recommended` version. Delete the `Recommended` version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that's not backward compatible.
     *
     * Delete a minor version of an environment template if it *isn't* the `Recommended` version. Delete a `Recommended` minor version of the environment template if no other minor versions of the environment template exist. A minor version of an environment template is a version that's backward compatible.
     */
    override suspend fun deleteEnvironmentTemplateVersion(input: DeleteEnvironmentTemplateVersionRequest): DeleteEnvironmentTemplateVersionResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentTemplateVersionRequest, DeleteEnvironmentTemplateVersionResponse> {
            serializer = DeleteEnvironmentTemplateVersionOperationSerializer()
            deserializer = DeleteEnvironmentTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEnvironmentTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * De-register and unlink your repository.
     */
    override suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse {
        val op = SdkHttpOperation.build<DeleteRepositoryRequest, DeleteRepositoryResponse> {
            serializer = DeleteRepositoryOperationSerializer()
            deserializer = DeleteRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a service, with its instances and pipeline.
     *
     * You can't delete a service if it has any service instances that have components attached to them.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse {
        val op = SdkHttpOperation.build<DeleteServiceRequest, DeleteServiceResponse> {
            serializer = DeleteServiceOperationSerializer()
            deserializer = DeleteServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If no other major or minor versions of the service template exist, delete the service template.
     */
    override suspend fun deleteServiceTemplate(input: DeleteServiceTemplateRequest): DeleteServiceTemplateResponse {
        val op = SdkHttpOperation.build<DeleteServiceTemplateRequest, DeleteServiceTemplateResponse> {
            serializer = DeleteServiceTemplateOperationSerializer()
            deserializer = DeleteServiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteServiceTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If no other minor versions of a service template exist, delete a major version of the service template if it's not the `Recommended` version. Delete the `Recommended` version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that *isn't* backwards compatible.
     *
     * Delete a minor version of a service template if it's not the `Recommended` version. Delete a `Recommended` minor version of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that's backwards compatible.
     */
    override suspend fun deleteServiceTemplateVersion(input: DeleteServiceTemplateVersionRequest): DeleteServiceTemplateVersionResponse {
        val op = SdkHttpOperation.build<DeleteServiceTemplateVersionRequest, DeleteServiceTemplateVersionResponse> {
            serializer = DeleteServiceTemplateVersionOperationSerializer()
            deserializer = DeleteServiceTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteServiceTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a template sync configuration.
     */
    override suspend fun deleteTemplateSyncConfig(input: DeleteTemplateSyncConfigRequest): DeleteTemplateSyncConfigResponse {
        val op = SdkHttpOperation.build<DeleteTemplateSyncConfigRequest, DeleteTemplateSyncConfigResponse> {
            serializer = DeleteTemplateSyncConfigOperationSerializer()
            deserializer = DeleteTemplateSyncConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTemplateSyncConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detail data for the Proton pipeline service role.
     */
    override suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse {
        val op = SdkHttpOperation.build<GetAccountSettingsRequest, GetAccountSettingsResponse> {
            serializer = GetAccountSettingsOperationSerializer()
            deserializer = GetAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a component.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun getComponent(input: GetComponentRequest): GetComponentResponse {
        val op = SdkHttpOperation.build<GetComponentRequest, GetComponentResponse> {
            serializer = GetComponentOperationSerializer()
            deserializer = GetComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for an environment.
     */
    override suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse {
        val op = SdkHttpOperation.build<GetEnvironmentRequest, GetEnvironmentResponse> {
            serializer = GetEnvironmentOperationSerializer()
            deserializer = GetEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * In an environment account, get the detailed data for an environment account connection.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun getEnvironmentAccountConnection(input: GetEnvironmentAccountConnectionRequest): GetEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<GetEnvironmentAccountConnectionRequest, GetEnvironmentAccountConnectionResponse> {
            serializer = GetEnvironmentAccountConnectionOperationSerializer()
            deserializer = GetEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for an environment template.
     */
    override suspend fun getEnvironmentTemplate(input: GetEnvironmentTemplateRequest): GetEnvironmentTemplateResponse {
        val op = SdkHttpOperation.build<GetEnvironmentTemplateRequest, GetEnvironmentTemplateResponse> {
            serializer = GetEnvironmentTemplateOperationSerializer()
            deserializer = GetEnvironmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnvironmentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a major or minor version of an environment template.
     */
    override suspend fun getEnvironmentTemplateVersion(input: GetEnvironmentTemplateVersionRequest): GetEnvironmentTemplateVersionResponse {
        val op = SdkHttpOperation.build<GetEnvironmentTemplateVersionRequest, GetEnvironmentTemplateVersionResponse> {
            serializer = GetEnvironmentTemplateVersionOperationSerializer()
            deserializer = GetEnvironmentTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnvironmentTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detail data for a repository.
     */
    override suspend fun getRepository(input: GetRepositoryRequest): GetRepositoryResponse {
        val op = SdkHttpOperation.build<GetRepositoryRequest, GetRepositoryResponse> {
            serializer = GetRepositoryOperationSerializer()
            deserializer = GetRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the sync status of a repository used for Proton template sync. For more information about template sync, see .
     *
     * A repository sync status isn't tied to the Proton Repository resource (or any other Proton resource). Therefore, tags on an Proton Repository resource have no effect on this action. Specifically, you can't use these tags to control access to this action using Attribute-based access control (ABAC).
     *
     * For more information about ABAC, see [ABAC](https://docs.aws.amazon.com/proton/latest/adminguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags) in the *Proton Administrator Guide*.
     */
    override suspend fun getRepositorySyncStatus(input: GetRepositorySyncStatusRequest): GetRepositorySyncStatusResponse {
        val op = SdkHttpOperation.build<GetRepositorySyncStatusRequest, GetRepositorySyncStatusResponse> {
            serializer = GetRepositorySyncStatusOperationSerializer()
            deserializer = GetRepositorySyncStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepositorySyncStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a service.
     */
    override suspend fun getService(input: GetServiceRequest): GetServiceResponse {
        val op = SdkHttpOperation.build<GetServiceRequest, GetServiceResponse> {
            serializer = GetServiceOperationSerializer()
            deserializer = GetServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a service instance. A service instance is an instantiation of service template and it runs in a specific environment.
     */
    override suspend fun getServiceInstance(input: GetServiceInstanceRequest): GetServiceInstanceResponse {
        val op = SdkHttpOperation.build<GetServiceInstanceRequest, GetServiceInstanceResponse> {
            serializer = GetServiceInstanceOperationSerializer()
            deserializer = GetServiceInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a service template.
     */
    override suspend fun getServiceTemplate(input: GetServiceTemplateRequest): GetServiceTemplateResponse {
        val op = SdkHttpOperation.build<GetServiceTemplateRequest, GetServiceTemplateResponse> {
            serializer = GetServiceTemplateOperationSerializer()
            deserializer = GetServiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detailed data for a major or minor version of a service template.
     */
    override suspend fun getServiceTemplateVersion(input: GetServiceTemplateVersionRequest): GetServiceTemplateVersionResponse {
        val op = SdkHttpOperation.build<GetServiceTemplateVersionRequest, GetServiceTemplateVersionResponse> {
            serializer = GetServiceTemplateVersionOperationSerializer()
            deserializer = GetServiceTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get detail data for a template sync configuration.
     */
    override suspend fun getTemplateSyncConfig(input: GetTemplateSyncConfigRequest): GetTemplateSyncConfigResponse {
        val op = SdkHttpOperation.build<GetTemplateSyncConfigRequest, GetTemplateSyncConfigResponse> {
            serializer = GetTemplateSyncConfigOperationSerializer()
            deserializer = GetTemplateSyncConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplateSyncConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the status of a template sync.
     */
    override suspend fun getTemplateSyncStatus(input: GetTemplateSyncStatusRequest): GetTemplateSyncStatusResponse {
        val op = SdkHttpOperation.build<GetTemplateSyncStatusRequest, GetTemplateSyncStatusResponse> {
            serializer = GetTemplateSyncStatusOperationSerializer()
            deserializer = GetTemplateSyncStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplateSyncStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of component Infrastructure as Code (IaC) outputs.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun listComponentOutputs(input: ListComponentOutputsRequest): ListComponentOutputsResponse {
        val op = SdkHttpOperation.build<ListComponentOutputsRequest, ListComponentOutputsResponse> {
            serializer = ListComponentOutputsOperationSerializer()
            deserializer = ListComponentOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponentOutputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List provisioned resources for a component with details.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun listComponentProvisionedResources(input: ListComponentProvisionedResourcesRequest): ListComponentProvisionedResourcesResponse {
        val op = SdkHttpOperation.build<ListComponentProvisionedResourcesRequest, ListComponentProvisionedResourcesResponse> {
            serializer = ListComponentProvisionedResourcesOperationSerializer()
            deserializer = ListComponentProvisionedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponentProvisionedResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List components with summary data. You can filter the result list by environment, service, or a single service instance.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * View a list of environment account connections.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun listEnvironmentAccountConnections(input: ListEnvironmentAccountConnectionsRequest): ListEnvironmentAccountConnectionsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentAccountConnectionsRequest, ListEnvironmentAccountConnectionsResponse> {
            serializer = ListEnvironmentAccountConnectionsOperationSerializer()
            deserializer = ListEnvironmentAccountConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironmentAccountConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the infrastructure as code outputs for your environment.
     */
    override suspend fun listEnvironmentOutputs(input: ListEnvironmentOutputsRequest): ListEnvironmentOutputsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentOutputsRequest, ListEnvironmentOutputsResponse> {
            serializer = ListEnvironmentOutputsOperationSerializer()
            deserializer = ListEnvironmentOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironmentOutputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the provisioned resources for your environment.
     */
    override suspend fun listEnvironmentProvisionedResources(input: ListEnvironmentProvisionedResourcesRequest): ListEnvironmentProvisionedResourcesResponse {
        val op = SdkHttpOperation.build<ListEnvironmentProvisionedResourcesRequest, ListEnvironmentProvisionedResourcesResponse> {
            serializer = ListEnvironmentProvisionedResourcesOperationSerializer()
            deserializer = ListEnvironmentProvisionedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironmentProvisionedResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List major or minor versions of an environment template with detail data.
     */
    override suspend fun listEnvironmentTemplateVersions(input: ListEnvironmentTemplateVersionsRequest): ListEnvironmentTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentTemplateVersionsRequest, ListEnvironmentTemplateVersionsResponse> {
            serializer = ListEnvironmentTemplateVersionsOperationSerializer()
            deserializer = ListEnvironmentTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironmentTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List environment templates.
     */
    override suspend fun listEnvironmentTemplates(input: ListEnvironmentTemplatesRequest): ListEnvironmentTemplatesResponse {
        val op = SdkHttpOperation.build<ListEnvironmentTemplatesRequest, ListEnvironmentTemplatesResponse> {
            serializer = ListEnvironmentTemplatesOperationSerializer()
            deserializer = ListEnvironmentTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironmentTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List environments with detail data summaries.
     */
    override suspend fun listEnvironments(input: ListEnvironmentsRequest): ListEnvironmentsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentsRequest, ListEnvironmentsResponse> {
            serializer = ListEnvironmentsOperationSerializer()
            deserializer = ListEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnvironments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List repositories with detail data.
     */
    override suspend fun listRepositories(input: ListRepositoriesRequest): ListRepositoriesResponse {
        val op = SdkHttpOperation.build<ListRepositoriesRequest, ListRepositoriesResponse> {
            serializer = ListRepositoriesOperationSerializer()
            deserializer = ListRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List repository sync definitions with detail data.
     */
    override suspend fun listRepositorySyncDefinitions(input: ListRepositorySyncDefinitionsRequest): ListRepositorySyncDefinitionsResponse {
        val op = SdkHttpOperation.build<ListRepositorySyncDefinitionsRequest, ListRepositorySyncDefinitionsResponse> {
            serializer = ListRepositorySyncDefinitionsOperationSerializer()
            deserializer = ListRepositorySyncDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositorySyncDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list service of instance Infrastructure as Code (IaC) outputs.
     */
    override suspend fun listServiceInstanceOutputs(input: ListServiceInstanceOutputsRequest): ListServiceInstanceOutputsResponse {
        val op = SdkHttpOperation.build<ListServiceInstanceOutputsRequest, ListServiceInstanceOutputsResponse> {
            serializer = ListServiceInstanceOutputsOperationSerializer()
            deserializer = ListServiceInstanceOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceInstanceOutputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List provisioned resources for a service instance with details.
     */
    override suspend fun listServiceInstanceProvisionedResources(input: ListServiceInstanceProvisionedResourcesRequest): ListServiceInstanceProvisionedResourcesResponse {
        val op = SdkHttpOperation.build<ListServiceInstanceProvisionedResourcesRequest, ListServiceInstanceProvisionedResourcesResponse> {
            serializer = ListServiceInstanceProvisionedResourcesOperationSerializer()
            deserializer = ListServiceInstanceProvisionedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceInstanceProvisionedResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List service instances with summary data.
     */
    override suspend fun listServiceInstances(input: ListServiceInstancesRequest): ListServiceInstancesResponse {
        val op = SdkHttpOperation.build<ListServiceInstancesRequest, ListServiceInstancesResponse> {
            serializer = ListServiceInstancesOperationSerializer()
            deserializer = ListServiceInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of service pipeline Infrastructure as Code (IaC) outputs.
     */
    override suspend fun listServicePipelineOutputs(input: ListServicePipelineOutputsRequest): ListServicePipelineOutputsResponse {
        val op = SdkHttpOperation.build<ListServicePipelineOutputsRequest, ListServicePipelineOutputsResponse> {
            serializer = ListServicePipelineOutputsOperationSerializer()
            deserializer = ListServicePipelineOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServicePipelineOutputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List provisioned resources for a service and pipeline with details.
     */
    override suspend fun listServicePipelineProvisionedResources(input: ListServicePipelineProvisionedResourcesRequest): ListServicePipelineProvisionedResourcesResponse {
        val op = SdkHttpOperation.build<ListServicePipelineProvisionedResourcesRequest, ListServicePipelineProvisionedResourcesResponse> {
            serializer = ListServicePipelineProvisionedResourcesOperationSerializer()
            deserializer = ListServicePipelineProvisionedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServicePipelineProvisionedResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List major or minor versions of a service template with detail data.
     */
    override suspend fun listServiceTemplateVersions(input: ListServiceTemplateVersionsRequest): ListServiceTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListServiceTemplateVersionsRequest, ListServiceTemplateVersionsResponse> {
            serializer = ListServiceTemplateVersionsOperationSerializer()
            deserializer = ListServiceTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List service templates with detail data.
     */
    override suspend fun listServiceTemplates(input: ListServiceTemplatesRequest): ListServiceTemplatesResponse {
        val op = SdkHttpOperation.build<ListServiceTemplatesRequest, ListServiceTemplatesResponse> {
            serializer = ListServiceTemplatesOperationSerializer()
            deserializer = ListServiceTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List services with summaries of detail data.
     */
    override suspend fun listServices(input: ListServicesRequest): ListServicesResponse {
        val op = SdkHttpOperation.build<ListServicesRequest, ListServicesResponse> {
            serializer = ListServicesOperationSerializer()
            deserializer = ListServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List tags for a resource. For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
     *
     * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self) in the *Proton Administrator Guide*.
     */
    override suspend fun notifyResourceDeploymentStatusChange(input: NotifyResourceDeploymentStatusChangeRequest): NotifyResourceDeploymentStatusChangeResponse {
        val op = SdkHttpOperation.build<NotifyResourceDeploymentStatusChangeRequest, NotifyResourceDeploymentStatusChangeResponse> {
            serializer = NotifyResourceDeploymentStatusChangeOperationSerializer()
            deserializer = NotifyResourceDeploymentStatusChangeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyResourceDeploymentStatusChange"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * In a management account, reject an environment account connection from another environment account.
     *
     * After you reject an environment account connection request, you *can't* accept or use the rejected environment account connection.
     *
     * You *can’t* reject an environment account connection that's connected to an environment.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun rejectEnvironmentAccountConnection(input: RejectEnvironmentAccountConnectionRequest): RejectEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<RejectEnvironmentAccountConnectionRequest, RejectEnvironmentAccountConnectionResponse> {
            serializer = RejectEnvironmentAccountConnectionOperationSerializer()
            deserializer = RejectEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the Proton service pipeline role or repository settings.
     */
    override suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse {
        val op = SdkHttpOperation.build<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse> {
            serializer = UpdateAccountSettingsOperationSerializer()
            deserializer = UpdateAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a component.
     *
     * There are a few modes for updating a component. The `deploymentType` field defines the mode.
     *
     * You can't update a component while its deployment status, or the deployment status of a service instance attached to it, is `IN_PROGRESS`.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse {
        val op = SdkHttpOperation.build<UpdateComponentRequest, UpdateComponentResponse> {
            serializer = UpdateComponentOperationSerializer()
            deserializer = UpdateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an environment.
     *
     * If the environment is associated with an environment account connection, *don't* update or include the `protonServiceRoleArn` and `provisioningRepository` parameter to update or connect to an environment account connection.
     *
     * You can only update to a new environment account connection if that connection was created in the same environment account that the current environment account connection was created in. The account connection must also be associated with the current environment.
     *
     * If the environment *isn't* associated with an environment account connection, *don't* update or include the `environmentAccountConnectionId` parameter. You *can't* update or connect the environment to an environment account connection if it *isn't* already associated with an environment connection.
     *
     * You can update either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and value. You can’t update both.
     *
     * If the environment was configured for Amazon Web Services-managed provisioning, omit the `provisioningRepository` parameter.
     *
     * If the environment was configured for self-managed provisioning, specify the `provisioningRepository` parameter and omit the `protonServiceRoleArn` and `environmentAccountConnectionId` parameters.
     *
     * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
     *
     * There are four modes for updating an environment. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include minor or major version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that's higher than the major version in use and a minor version.
     */
    override suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentRequest, UpdateEnvironmentResponse> {
            serializer = UpdateEnvironmentOperationSerializer()
            deserializer = UpdateEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * In an environment account, update an environment account connection to use a new IAM role.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    override suspend fun updateEnvironmentAccountConnection(input: UpdateEnvironmentAccountConnectionRequest): UpdateEnvironmentAccountConnectionResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentAccountConnectionRequest, UpdateEnvironmentAccountConnectionResponse> {
            serializer = UpdateEnvironmentAccountConnectionOperationSerializer()
            deserializer = UpdateEnvironmentAccountConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnvironmentAccountConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an environment template.
     */
    override suspend fun updateEnvironmentTemplate(input: UpdateEnvironmentTemplateRequest): UpdateEnvironmentTemplateResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentTemplateRequest, UpdateEnvironmentTemplateResponse> {
            serializer = UpdateEnvironmentTemplateOperationSerializer()
            deserializer = UpdateEnvironmentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnvironmentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a major or minor version of an environment template.
     */
    override suspend fun updateEnvironmentTemplateVersion(input: UpdateEnvironmentTemplateVersionRequest): UpdateEnvironmentTemplateVersionResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentTemplateVersionRequest, UpdateEnvironmentTemplateVersionResponse> {
            serializer = UpdateEnvironmentTemplateVersionOperationSerializer()
            deserializer = UpdateEnvironmentTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnvironmentTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Edit a service description or use a spec to add and delete service instances.
     *
     * Existing service instances and the service pipeline *can't* be edited using this API. They can only be deleted.
     *
     * Use the `description` parameter to modify the description.
     *
     * Edit the `spec` parameter to add or delete instances.
     *
     * You can't delete a service instance (remove it from the spec) if it has an attached component.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse {
        val op = SdkHttpOperation.build<UpdateServiceRequest, UpdateServiceResponse> {
            serializer = UpdateServiceOperationSerializer()
            deserializer = UpdateServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a service instance.
     *
     * There are a few modes for updating a service instance. The `deploymentType` field defines the mode.
     *
     * You can't update a service instance while its deployment status, or the deployment status of a component attached to it, is `IN_PROGRESS`.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    override suspend fun updateServiceInstance(input: UpdateServiceInstanceRequest): UpdateServiceInstanceResponse {
        val op = SdkHttpOperation.build<UpdateServiceInstanceRequest, UpdateServiceInstanceResponse> {
            serializer = UpdateServiceInstanceOperationSerializer()
            deserializer = UpdateServiceInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the service pipeline.
     *
     * There are four modes for updating a service pipeline. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template by default. You can specify a different major version that's higher than the major version in use and a minor version.
     */
    override suspend fun updateServicePipeline(input: UpdateServicePipelineRequest): UpdateServicePipelineResponse {
        val op = SdkHttpOperation.build<UpdateServicePipelineRequest, UpdateServicePipelineResponse> {
            serializer = UpdateServicePipelineOperationSerializer()
            deserializer = UpdateServicePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServicePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a service template.
     */
    override suspend fun updateServiceTemplate(input: UpdateServiceTemplateRequest): UpdateServiceTemplateResponse {
        val op = SdkHttpOperation.build<UpdateServiceTemplateRequest, UpdateServiceTemplateResponse> {
            serializer = UpdateServiceTemplateOperationSerializer()
            deserializer = UpdateServiceTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a major or minor version of a service template.
     */
    override suspend fun updateServiceTemplateVersion(input: UpdateServiceTemplateVersionRequest): UpdateServiceTemplateVersionResponse {
        val op = SdkHttpOperation.build<UpdateServiceTemplateVersionRequest, UpdateServiceTemplateVersionResponse> {
            serializer = UpdateServiceTemplateVersionOperationSerializer()
            deserializer = UpdateServiceTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update template sync configuration parameters, except for the `templateName` and `templateType`.
     */
    override suspend fun updateTemplateSyncConfig(input: UpdateTemplateSyncConfigRequest): UpdateTemplateSyncConfigResponse {
        val op = SdkHttpOperation.build<UpdateTemplateSyncConfigRequest, UpdateTemplateSyncConfigResponse> {
            serializer = UpdateTemplateSyncConfigOperationSerializer()
            deserializer = UpdateTemplateSyncConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTemplateSyncConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AwsProton20200720", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "proton"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "proton")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
