// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.proton.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.proton.model.*
import aws.sdk.kotlin.services.proton.model.AcceptEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.AcceptEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.CancelComponentDeploymentRequest
import aws.sdk.kotlin.services.proton.model.CancelComponentDeploymentResponse
import aws.sdk.kotlin.services.proton.model.CancelEnvironmentDeploymentRequest
import aws.sdk.kotlin.services.proton.model.CancelEnvironmentDeploymentResponse
import aws.sdk.kotlin.services.proton.model.CancelServiceInstanceDeploymentRequest
import aws.sdk.kotlin.services.proton.model.CancelServiceInstanceDeploymentResponse
import aws.sdk.kotlin.services.proton.model.CancelServicePipelineDeploymentRequest
import aws.sdk.kotlin.services.proton.model.CancelServicePipelineDeploymentResponse
import aws.sdk.kotlin.services.proton.model.CreateComponentRequest
import aws.sdk.kotlin.services.proton.model.CreateComponentResponse
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateRequest
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateResponse
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.CreateRepositoryRequest
import aws.sdk.kotlin.services.proton.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.proton.model.CreateServiceRequest
import aws.sdk.kotlin.services.proton.model.CreateServiceResponse
import aws.sdk.kotlin.services.proton.model.CreateServiceTemplateRequest
import aws.sdk.kotlin.services.proton.model.CreateServiceTemplateResponse
import aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.CreateTemplateSyncConfigRequest
import aws.sdk.kotlin.services.proton.model.CreateTemplateSyncConfigResponse
import aws.sdk.kotlin.services.proton.model.DeleteComponentRequest
import aws.sdk.kotlin.services.proton.model.DeleteComponentResponse
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentTemplateRequest
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentTemplateResponse
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.DeleteEnvironmentTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.DeleteRepositoryRequest
import aws.sdk.kotlin.services.proton.model.DeleteRepositoryResponse
import aws.sdk.kotlin.services.proton.model.DeleteServiceRequest
import aws.sdk.kotlin.services.proton.model.DeleteServiceResponse
import aws.sdk.kotlin.services.proton.model.DeleteServiceTemplateRequest
import aws.sdk.kotlin.services.proton.model.DeleteServiceTemplateResponse
import aws.sdk.kotlin.services.proton.model.DeleteServiceTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.DeleteServiceTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.DeleteTemplateSyncConfigRequest
import aws.sdk.kotlin.services.proton.model.DeleteTemplateSyncConfigResponse
import aws.sdk.kotlin.services.proton.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.proton.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.proton.model.GetComponentRequest
import aws.sdk.kotlin.services.proton.model.GetComponentResponse
import aws.sdk.kotlin.services.proton.model.GetEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.GetEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.proton.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.proton.model.GetEnvironmentTemplateRequest
import aws.sdk.kotlin.services.proton.model.GetEnvironmentTemplateResponse
import aws.sdk.kotlin.services.proton.model.GetEnvironmentTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.GetEnvironmentTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.GetRepositoryRequest
import aws.sdk.kotlin.services.proton.model.GetRepositoryResponse
import aws.sdk.kotlin.services.proton.model.GetRepositorySyncStatusRequest
import aws.sdk.kotlin.services.proton.model.GetRepositorySyncStatusResponse
import aws.sdk.kotlin.services.proton.model.GetServiceInstanceRequest
import aws.sdk.kotlin.services.proton.model.GetServiceInstanceResponse
import aws.sdk.kotlin.services.proton.model.GetServiceRequest
import aws.sdk.kotlin.services.proton.model.GetServiceResponse
import aws.sdk.kotlin.services.proton.model.GetServiceTemplateRequest
import aws.sdk.kotlin.services.proton.model.GetServiceTemplateResponse
import aws.sdk.kotlin.services.proton.model.GetServiceTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.GetServiceTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.GetTemplateSyncConfigRequest
import aws.sdk.kotlin.services.proton.model.GetTemplateSyncConfigResponse
import aws.sdk.kotlin.services.proton.model.GetTemplateSyncStatusRequest
import aws.sdk.kotlin.services.proton.model.GetTemplateSyncStatusResponse
import aws.sdk.kotlin.services.proton.model.ListComponentOutputsRequest
import aws.sdk.kotlin.services.proton.model.ListComponentOutputsResponse
import aws.sdk.kotlin.services.proton.model.ListComponentProvisionedResourcesRequest
import aws.sdk.kotlin.services.proton.model.ListComponentProvisionedResourcesResponse
import aws.sdk.kotlin.services.proton.model.ListComponentsRequest
import aws.sdk.kotlin.services.proton.model.ListComponentsResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentAccountConnectionsRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentAccountConnectionsResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentOutputsRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentOutputsResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentProvisionedResourcesRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentProvisionedResourcesResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentTemplateVersionsRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentTemplateVersionsResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentTemplatesRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentTemplatesResponse
import aws.sdk.kotlin.services.proton.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.proton.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.proton.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.proton.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.proton.model.ListRepositorySyncDefinitionsRequest
import aws.sdk.kotlin.services.proton.model.ListRepositorySyncDefinitionsResponse
import aws.sdk.kotlin.services.proton.model.ListServiceInstanceOutputsRequest
import aws.sdk.kotlin.services.proton.model.ListServiceInstanceOutputsResponse
import aws.sdk.kotlin.services.proton.model.ListServiceInstanceProvisionedResourcesRequest
import aws.sdk.kotlin.services.proton.model.ListServiceInstanceProvisionedResourcesResponse
import aws.sdk.kotlin.services.proton.model.ListServiceInstancesRequest
import aws.sdk.kotlin.services.proton.model.ListServiceInstancesResponse
import aws.sdk.kotlin.services.proton.model.ListServicePipelineOutputsRequest
import aws.sdk.kotlin.services.proton.model.ListServicePipelineOutputsResponse
import aws.sdk.kotlin.services.proton.model.ListServicePipelineProvisionedResourcesRequest
import aws.sdk.kotlin.services.proton.model.ListServicePipelineProvisionedResourcesResponse
import aws.sdk.kotlin.services.proton.model.ListServiceTemplateVersionsRequest
import aws.sdk.kotlin.services.proton.model.ListServiceTemplateVersionsResponse
import aws.sdk.kotlin.services.proton.model.ListServiceTemplatesRequest
import aws.sdk.kotlin.services.proton.model.ListServiceTemplatesResponse
import aws.sdk.kotlin.services.proton.model.ListServicesRequest
import aws.sdk.kotlin.services.proton.model.ListServicesResponse
import aws.sdk.kotlin.services.proton.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.proton.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
import aws.sdk.kotlin.services.proton.model.NotifyResourceDeploymentStatusChangeResponse
import aws.sdk.kotlin.services.proton.model.RejectEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.RejectEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.TagResourceRequest
import aws.sdk.kotlin.services.proton.model.TagResourceResponse
import aws.sdk.kotlin.services.proton.model.UntagResourceRequest
import aws.sdk.kotlin.services.proton.model.UntagResourceResponse
import aws.sdk.kotlin.services.proton.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.proton.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.proton.model.UpdateComponentRequest
import aws.sdk.kotlin.services.proton.model.UpdateComponentResponse
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionRequest
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionResponse
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentResponse
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentTemplateRequest
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentTemplateResponse
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.UpdateEnvironmentTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceRequest
import aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceResponse
import aws.sdk.kotlin.services.proton.model.UpdateServicePipelineRequest
import aws.sdk.kotlin.services.proton.model.UpdateServicePipelineResponse
import aws.sdk.kotlin.services.proton.model.UpdateServiceRequest
import aws.sdk.kotlin.services.proton.model.UpdateServiceResponse
import aws.sdk.kotlin.services.proton.model.UpdateServiceTemplateRequest
import aws.sdk.kotlin.services.proton.model.UpdateServiceTemplateResponse
import aws.sdk.kotlin.services.proton.model.UpdateServiceTemplateVersionRequest
import aws.sdk.kotlin.services.proton.model.UpdateServiceTemplateVersionResponse
import aws.sdk.kotlin.services.proton.model.UpdateTemplateSyncConfigRequest
import aws.sdk.kotlin.services.proton.model.UpdateTemplateSyncConfigResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the Proton Service API Reference. It provides descriptions, syntax and usage examples for each of the [actions](https://docs.aws.amazon.com/proton/latest/APIReference/API_Operations.html) and [data types](https://docs.aws.amazon.com/proton/latest/APIReference/API_Types.html) for the Proton service.
 *
 * The documentation for each action shows the Query API request parameters and the XML response.
 *
 * Alternatively, you can use the Amazon Web Services CLI to access an API. For more information, see the [Amazon Web Services Command Line Interface User Guide](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html).
 *
 * The Proton service is a two-pronged automation framework. Administrators create service templates to provide standardized infrastructure and deployment tooling for serverless and container based applications. Developers, in turn, select from the available service templates to automate their application or service deployments.
 *
 * Because administrators define the infrastructure and tooling that Proton deploys and manages, they need permissions to use all of the listed API operations.
 *
 * When developers select a specific infrastructure and tooling set, Proton deploys their applications. To monitor their applications that are running on Proton, developers need permissions to the service *create*, *list*, *update* and *delete* API operations and the service instance *list* and *update* API operations.
 *
 * To learn more about Proton administration, see the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/Welcome.html).
 *
 * To learn more about deploying serverless and containerized applications on Proton, see the [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/Welcome.html).
 *
 * **Ensuring Idempotency**
 *
 * When you make a mutating API request, the request typically returns a result before the asynchronous workflows of the operation are complete. Operations might also time out or encounter other server issues before they're complete, even if the request already returned a result. This might make it difficult to determine whether the request succeeded. Moreover, you might need to retry the request multiple times to ensure that the operation completes successfully. However, if the original request and the subsequent retries are successful, the operation occurs multiple times. This means that you might create more resources than you intended.
 *
 * *Idempotency* ensures that an API request action completes no more than one time. With an idempotent request, if the original request action completes successfully, any subsequent retries complete successfully without performing any further actions. However, the result might contain updated information, such as the current creation status.
 *
 * The following lists of APIs are grouped according to methods that ensure idempotency.
 *
 * **Idempotent create APIs with a client token**
 *
 * The API actions in this list support idempotency with the use of a *client token*. The corresponding Amazon Web Services CLI commands also support idempotency using a client token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client token in the request. We recommend that you *don't* reuse the same client token for other API requests. If you don’t provide a client token for these APIs, a default client token is automatically provided by SDKs.
 *
 * Given a request action that has succeeded:
 *
 * If you retry the request using the same client token and the same parameters, the retry succeeds without performing any further actions other than returning the original resource detail data in the response.
 *
 * If you retry the request using the same client token, but one or more of the parameters are different, the retry throws a `ValidationException` with an `IdempotentParameterMismatch` error.
 *
 * Client tokens expire eight hours after a request is made. If you retry the request with the expired token, a new resource is created.
 *
 * If the original resource is deleted and you retry the request, a new resource is created.
 *
 * Idempotent create APIs with a client token:
 * + CreateEnvironmentTemplateVersion
 * + CreateServiceTemplateVersion
 * + CreateEnvironmentAccountConnection
 *
 * **Idempotent create APIs**
 *
 * Given a request action that has succeeded:
 *
 * If you retry the request with an API from this group, and the original resource *hasn't* been modified, the retry succeeds without performing any further actions other than returning the original resource detail data in the response.
 *
 * If the original resource has been modified, the retry throws a `ConflictException`.
 *
 * If you retry with different input parameters, the retry throws a `ValidationException` with an `IdempotentParameterMismatch` error.
 *
 * Idempotent create APIs:
 * + CreateEnvironmentTemplate
 * + CreateServiceTemplate
 * + CreateEnvironment
 * + CreateService
 *
 * **Idempotent delete APIs**
 *
 * Given a request action that has succeeded:
 *
 * When you retry the request with an API from this group and the resource was deleted, its metadata is returned in the response.
 *
 * If you retry and the resource doesn't exist, the response is empty.
 *
 * In both cases, the retry succeeds.
 *
 * Idempotent delete APIs:
 * + DeleteEnvironmentTemplate
 * + DeleteEnvironmentTemplateVersion
 * + DeleteServiceTemplate
 * + DeleteServiceTemplateVersion
 * + DeleteEnvironmentAccountConnection
 *
 * **Asynchronous idempotent delete APIs**
 *
 * Given a request action that has succeeded:
 *
 * If you retry the request with an API from this group, if the original request delete operation status is `DELETE_IN_PROGRESS`, the retry returns the resource detail data in the response without performing any further actions.
 *
 * If the original request delete operation is complete, a retry returns an empty response.
 *
 * Asynchronous idempotent delete APIs:
 * + DeleteEnvironment
 * + DeleteService
 */
public interface ProtonClient : SdkClient {

    override val serviceName: String
        get() = "Proton"
    /**
     * ProtonClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ProtonClient {
            val config = Config.Builder().apply(block).build()
            return DefaultProtonClient(config)
        }

        public operator fun invoke(config: Config): ProtonClient = DefaultProtonClient(config)

        /**
         * Construct a [ProtonClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ProtonClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultProtonClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun acceptEnvironmentAccountConnection(input: AcceptEnvironmentAccountConnectionRequest): AcceptEnvironmentAccountConnectionResponse

    /**
     * Attempts to cancel a component deployment (for a component that is in the `IN_PROGRESS` deployment status).
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun cancelComponentDeployment(input: CancelComponentDeploymentRequest): CancelComponentDeploymentResponse

    /**
     * Attempts to cancel an environment deployment on an UpdateEnvironment action, if the deployment is `IN_PROGRESS`. For more information, see [Update an environment](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-update.html) in the *Proton Administrator guide*.
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateEnvironment action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    public suspend fun cancelEnvironmentDeployment(input: CancelEnvironmentDeploymentRequest): CancelEnvironmentDeploymentResponse

    /**
     * Attempts to cancel a service instance deployment on an UpdateServiceInstance action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service instance* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-instance-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-instance-update.html).
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateServiceInstance action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    public suspend fun cancelServiceInstanceDeployment(input: CancelServiceInstanceDeploymentRequest): CancelServiceInstanceDeploymentResponse

    /**
     * Attempts to cancel a service pipeline deployment on an UpdateServicePipeline action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service pipeline* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-pipeline-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-pipeline-update.html).
     *
     * The following list includes potential cancellation scenarios.
     * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
     * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
     * + If the current UpdateServicePipeline action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
     */
    public suspend fun cancelServicePipelineDeployment(input: CancelServicePipelineDeploymentRequest): CancelServicePipelineDeploymentResponse

    /**
     * Create an Proton component. A component is an infrastructure extension for a service instance.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.
     *
     * **You can provision environments using the following methods:**
     * + Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.
     * + Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as code (IaC) files that your IaC engine uses to provision resources.
     *
     * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.
     *
     * An environment account connection is a secure bi-directional connection between a *management account* and an *environment account* that maintains authorization and permissions. For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun createEnvironmentAccountConnection(input: CreateEnvironmentAccountConnectionRequest): CreateEnvironmentAccountConnectionResponse

    /**
     * Create an environment template for Proton. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the *Proton Administrator Guide*.
     *
     * You can create an environment template in one of the two following ways:
     * + Register and publish a *standard* environment template that instructs Proton to deploy and manage environment infrastructure.
     * + Register and publish a *customer managed* environment template that connects Proton to your existing provisioned infrastructure that you manage. Proton *doesn't* manage your existing provisioned infrastructure. To create an environment template for customer provisioned and managed infrastructure, include the `provisioning` parameter and set the value to `CUSTOMER_MANAGED`. For more information, see [Register and publish an environment template](https://docs.aws.amazon.com/proton/latest/adminguide/template-create.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createEnvironmentTemplate(input: CreateEnvironmentTemplateRequest): CreateEnvironmentTemplateResponse

    /**
     * Create a new major or minor version of an environment template. A major version of an environment template is a version that *isn't* backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.
     */
    public suspend fun createEnvironmentTemplateVersion(input: CreateEnvironmentTemplateVersionRequest): CreateEnvironmentTemplateVersionResponse

    /**
     * Create and register a link to a repository that can be used with self-managed provisioning (infrastructure or pipelines) or for template sync configurations. When you create a repository link, Proton creates a [service-linked role](https://docs.aws.amazon.com/proton/latest/adminguide/using-service-linked-roles.html) for you.
     *
     * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self), [Template bundles](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html), and [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see [Services](https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html) in the *Proton Administrator Guide* and [Services](https://docs.aws.amazon.com/proton/latest/userguide/ug-service.html) in the *Proton User Guide*.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see [Service Templates](https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createServiceTemplate(input: CreateServiceTemplateRequest): CreateServiceTemplateResponse

    /**
     * Create a new major or minor version of a service template. A major version of a service template is a version that *isn't* backward compatible. A minor version of a service template is a version that's backward compatible within its major version.
     */
    public suspend fun createServiceTemplateVersion(input: CreateServiceTemplateVersionRequest): CreateServiceTemplateVersionResponse

    /**
     * Set up a template to create new template versions automatically. When a commit is pushed to your registered [repository](https://docs.aws.amazon.com/proton/latest/APIReference/API_Repository.html), Proton checks for changes to your repository template bundles. If it detects a template bundle change, a new major or minor version of its template is created, if the version doesn’t already exist. For more information, see [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
     */
    public suspend fun createTemplateSyncConfig(input: CreateTemplateSyncConfigRequest): CreateTemplateSyncConfigResponse

    /**
     * Delete an Proton component resource.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Delete an environment.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * In an environment account, delete an environment account connection.
     *
     * After you delete an environment account connection that’s in use by an Proton environment, Proton *can’t* manage the environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment. You're responsible for cleaning up provisioned resources that remain without an environment connection.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun deleteEnvironmentAccountConnection(input: DeleteEnvironmentAccountConnectionRequest): DeleteEnvironmentAccountConnectionResponse

    /**
     * If no other major or minor versions of an environment template exist, delete the environment template.
     */
    public suspend fun deleteEnvironmentTemplate(input: DeleteEnvironmentTemplateRequest): DeleteEnvironmentTemplateResponse

    /**
     * If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the `Recommended` version. Delete the `Recommended` version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that's not backward compatible.
     *
     * Delete a minor version of an environment template if it *isn't* the `Recommended` version. Delete a `Recommended` minor version of the environment template if no other minor versions of the environment template exist. A minor version of an environment template is a version that's backward compatible.
     */
    public suspend fun deleteEnvironmentTemplateVersion(input: DeleteEnvironmentTemplateVersionRequest): DeleteEnvironmentTemplateVersionResponse

    /**
     * De-register and unlink your repository.
     */
    public suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Delete a service, with its instances and pipeline.
     *
     * You can't delete a service if it has any service instances that have components attached to them.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * If no other major or minor versions of the service template exist, delete the service template.
     */
    public suspend fun deleteServiceTemplate(input: DeleteServiceTemplateRequest): DeleteServiceTemplateResponse

    /**
     * If no other minor versions of a service template exist, delete a major version of the service template if it's not the `Recommended` version. Delete the `Recommended` version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that *isn't* backwards compatible.
     *
     * Delete a minor version of a service template if it's not the `Recommended` version. Delete a `Recommended` minor version of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that's backwards compatible.
     */
    public suspend fun deleteServiceTemplateVersion(input: DeleteServiceTemplateVersionRequest): DeleteServiceTemplateVersionResponse

    /**
     * Delete a template sync configuration.
     */
    public suspend fun deleteTemplateSyncConfig(input: DeleteTemplateSyncConfigRequest): DeleteTemplateSyncConfigResponse

    /**
     * Get detail data for the Proton pipeline service role.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest {}): GetAccountSettingsResponse

    /**
     * Get detailed data for a component.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Get detailed data for an environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * In an environment account, get the detailed data for an environment account connection.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun getEnvironmentAccountConnection(input: GetEnvironmentAccountConnectionRequest): GetEnvironmentAccountConnectionResponse

    /**
     * Get detailed data for an environment template.
     */
    public suspend fun getEnvironmentTemplate(input: GetEnvironmentTemplateRequest): GetEnvironmentTemplateResponse

    /**
     * Get detailed data for a major or minor version of an environment template.
     */
    public suspend fun getEnvironmentTemplateVersion(input: GetEnvironmentTemplateVersionRequest): GetEnvironmentTemplateVersionResponse

    /**
     * Get detail data for a repository.
     */
    public suspend fun getRepository(input: GetRepositoryRequest): GetRepositoryResponse

    /**
     * Get the sync status of a repository used for Proton template sync. For more information about template sync, see .
     *
     * A repository sync status isn't tied to the Proton Repository resource (or any other Proton resource). Therefore, tags on an Proton Repository resource have no effect on this action. Specifically, you can't use these tags to control access to this action using Attribute-based access control (ABAC).
     *
     * For more information about ABAC, see [ABAC](https://docs.aws.amazon.com/proton/latest/adminguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags) in the *Proton Administrator Guide*.
     */
    public suspend fun getRepositorySyncStatus(input: GetRepositorySyncStatusRequest): GetRepositorySyncStatusResponse

    /**
     * Get detailed data for a service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Get detailed data for a service instance. A service instance is an instantiation of service template and it runs in a specific environment.
     */
    public suspend fun getServiceInstance(input: GetServiceInstanceRequest): GetServiceInstanceResponse

    /**
     * Get detailed data for a service template.
     */
    public suspend fun getServiceTemplate(input: GetServiceTemplateRequest): GetServiceTemplateResponse

    /**
     * Get detailed data for a major or minor version of a service template.
     */
    public suspend fun getServiceTemplateVersion(input: GetServiceTemplateVersionRequest): GetServiceTemplateVersionResponse

    /**
     * Get detail data for a template sync configuration.
     */
    public suspend fun getTemplateSyncConfig(input: GetTemplateSyncConfigRequest): GetTemplateSyncConfigResponse

    /**
     * Get the status of a template sync.
     */
    public suspend fun getTemplateSyncStatus(input: GetTemplateSyncStatusRequest): GetTemplateSyncStatusResponse

    /**
     * Get a list of component Infrastructure as Code (IaC) outputs.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun listComponentOutputs(input: ListComponentOutputsRequest): ListComponentOutputsResponse

    /**
     * List provisioned resources for a component with details.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun listComponentProvisionedResources(input: ListComponentProvisionedResourcesRequest): ListComponentProvisionedResourcesResponse

    /**
     * List components with summary data. You can filter the result list by environment, service, or a single service instance.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun listComponents(input: ListComponentsRequest = ListComponentsRequest {}): ListComponentsResponse

    /**
     * View a list of environment account connections.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun listEnvironmentAccountConnections(input: ListEnvironmentAccountConnectionsRequest): ListEnvironmentAccountConnectionsResponse

    /**
     * List the infrastructure as code outputs for your environment.
     */
    public suspend fun listEnvironmentOutputs(input: ListEnvironmentOutputsRequest): ListEnvironmentOutputsResponse

    /**
     * List the provisioned resources for your environment.
     */
    public suspend fun listEnvironmentProvisionedResources(input: ListEnvironmentProvisionedResourcesRequest): ListEnvironmentProvisionedResourcesResponse

    /**
     * List major or minor versions of an environment template with detail data.
     */
    public suspend fun listEnvironmentTemplateVersions(input: ListEnvironmentTemplateVersionsRequest): ListEnvironmentTemplateVersionsResponse

    /**
     * List environment templates.
     */
    public suspend fun listEnvironmentTemplates(input: ListEnvironmentTemplatesRequest = ListEnvironmentTemplatesRequest {}): ListEnvironmentTemplatesResponse

    /**
     * List environments with detail data summaries.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest {}): ListEnvironmentsResponse

    /**
     * List repositories with detail data.
     */
    public suspend fun listRepositories(input: ListRepositoriesRequest = ListRepositoriesRequest {}): ListRepositoriesResponse

    /**
     * List repository sync definitions with detail data.
     */
    public suspend fun listRepositorySyncDefinitions(input: ListRepositorySyncDefinitionsRequest): ListRepositorySyncDefinitionsResponse

    /**
     * Get a list service of instance Infrastructure as Code (IaC) outputs.
     */
    public suspend fun listServiceInstanceOutputs(input: ListServiceInstanceOutputsRequest): ListServiceInstanceOutputsResponse

    /**
     * List provisioned resources for a service instance with details.
     */
    public suspend fun listServiceInstanceProvisionedResources(input: ListServiceInstanceProvisionedResourcesRequest): ListServiceInstanceProvisionedResourcesResponse

    /**
     * List service instances with summary data.
     */
    public suspend fun listServiceInstances(input: ListServiceInstancesRequest = ListServiceInstancesRequest {}): ListServiceInstancesResponse

    /**
     * Get a list of service pipeline Infrastructure as Code (IaC) outputs.
     */
    public suspend fun listServicePipelineOutputs(input: ListServicePipelineOutputsRequest): ListServicePipelineOutputsResponse

    /**
     * List provisioned resources for a service and pipeline with details.
     */
    public suspend fun listServicePipelineProvisionedResources(input: ListServicePipelineProvisionedResourcesRequest): ListServicePipelineProvisionedResourcesResponse

    /**
     * List major or minor versions of a service template with detail data.
     */
    public suspend fun listServiceTemplateVersions(input: ListServiceTemplateVersionsRequest): ListServiceTemplateVersionsResponse

    /**
     * List service templates with detail data.
     */
    public suspend fun listServiceTemplates(input: ListServiceTemplatesRequest = ListServiceTemplatesRequest {}): ListServiceTemplatesResponse

    /**
     * List services with summaries of detail data.
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest {}): ListServicesResponse

    /**
     * List tags for a resource. For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
     *
     * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self) in the *Proton Administrator Guide*.
     */
    public suspend fun notifyResourceDeploymentStatusChange(input: NotifyResourceDeploymentStatusChangeRequest): NotifyResourceDeploymentStatusChangeResponse

    /**
     * In a management account, reject an environment account connection from another environment account.
     *
     * After you reject an environment account connection request, you *can't* accept or use the rejected environment account connection.
     *
     * You *can’t* reject an environment account connection that's connected to an environment.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun rejectEnvironmentAccountConnection(input: RejectEnvironmentAccountConnectionRequest): RejectEnvironmentAccountConnectionResponse

    /**
     * Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the Proton service pipeline role or repository settings.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest {}): UpdateAccountSettingsResponse

    /**
     * Update a component.
     *
     * There are a few modes for updating a component. The `deploymentType` field defines the mode.
     *
     * You can't update a component while its deployment status, or the deployment status of a service instance attached to it, is `IN_PROGRESS`.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Update an environment.
     *
     * If the environment is associated with an environment account connection, *don't* update or include the `protonServiceRoleArn` and `provisioningRepository` parameter to update or connect to an environment account connection.
     *
     * You can only update to a new environment account connection if that connection was created in the same environment account that the current environment account connection was created in. The account connection must also be associated with the current environment.
     *
     * If the environment *isn't* associated with an environment account connection, *don't* update or include the `environmentAccountConnectionId` parameter. You *can't* update or connect the environment to an environment account connection if it *isn't* already associated with an environment connection.
     *
     * You can update either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and value. You can’t update both.
     *
     * If the environment was configured for Amazon Web Services-managed provisioning, omit the `provisioningRepository` parameter.
     *
     * If the environment was configured for self-managed provisioning, specify the `provisioningRepository` parameter and omit the `protonServiceRoleArn` and `environmentAccountConnectionId` parameters.
     *
     * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
     *
     * There are four modes for updating an environment. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include minor or major version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that's higher than the major version in use and a minor version.
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * In an environment account, update an environment account connection to use a new IAM role.
     *
     * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     */
    public suspend fun updateEnvironmentAccountConnection(input: UpdateEnvironmentAccountConnectionRequest): UpdateEnvironmentAccountConnectionResponse

    /**
     * Update an environment template.
     */
    public suspend fun updateEnvironmentTemplate(input: UpdateEnvironmentTemplateRequest): UpdateEnvironmentTemplateResponse

    /**
     * Update a major or minor version of an environment template.
     */
    public suspend fun updateEnvironmentTemplateVersion(input: UpdateEnvironmentTemplateVersionRequest): UpdateEnvironmentTemplateVersionResponse

    /**
     * Edit a service description or use a spec to add and delete service instances.
     *
     * Existing service instances and the service pipeline *can't* be edited using this API. They can only be deleted.
     *
     * Use the `description` parameter to modify the description.
     *
     * Edit the `spec` parameter to add or delete instances.
     *
     * You can't delete a service instance (remove it from the spec) if it has an attached component.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse

    /**
     * Update a service instance.
     *
     * There are a few modes for updating a service instance. The `deploymentType` field defines the mode.
     *
     * You can't update a service instance while its deployment status, or the deployment status of a component attached to it, is `IN_PROGRESS`.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public suspend fun updateServiceInstance(input: UpdateServiceInstanceRequest): UpdateServiceInstanceResponse

    /**
     * Update the service pipeline.
     *
     * There are four modes for updating a service pipeline. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template by default. You can specify a different major version that's higher than the major version in use and a minor version.
     */
    public suspend fun updateServicePipeline(input: UpdateServicePipelineRequest): UpdateServicePipelineResponse

    /**
     * Update a service template.
     */
    public suspend fun updateServiceTemplate(input: UpdateServiceTemplateRequest): UpdateServiceTemplateResponse

    /**
     * Update a major or minor version of a service template.
     */
    public suspend fun updateServiceTemplateVersion(input: UpdateServiceTemplateVersionRequest): UpdateServiceTemplateVersionResponse

    /**
     * Update template sync configuration parameters, except for the `templateName` and `templateType`.
     */
    public suspend fun updateTemplateSyncConfig(input: UpdateTemplateSyncConfigRequest): UpdateTemplateSyncConfigResponse
}

/**
 * In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.acceptEnvironmentAccountConnection(crossinline block: AcceptEnvironmentAccountConnectionRequest.Builder.() -> Unit): AcceptEnvironmentAccountConnectionResponse = acceptEnvironmentAccountConnection(AcceptEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * Attempts to cancel a component deployment (for a component that is in the `IN_PROGRESS` deployment status).
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.cancelComponentDeployment(crossinline block: CancelComponentDeploymentRequest.Builder.() -> Unit): CancelComponentDeploymentResponse = cancelComponentDeployment(CancelComponentDeploymentRequest.Builder().apply(block).build())

/**
 * Attempts to cancel an environment deployment on an UpdateEnvironment action, if the deployment is `IN_PROGRESS`. For more information, see [Update an environment](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-update.html) in the *Proton Administrator guide*.
 *
 * The following list includes potential cancellation scenarios.
 * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
 * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
 * + If the current UpdateEnvironment action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
 */
public suspend inline fun ProtonClient.cancelEnvironmentDeployment(crossinline block: CancelEnvironmentDeploymentRequest.Builder.() -> Unit): CancelEnvironmentDeploymentResponse = cancelEnvironmentDeployment(CancelEnvironmentDeploymentRequest.Builder().apply(block).build())

/**
 * Attempts to cancel a service instance deployment on an UpdateServiceInstance action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service instance* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-instance-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-instance-update.html).
 *
 * The following list includes potential cancellation scenarios.
 * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
 * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
 * + If the current UpdateServiceInstance action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
 */
public suspend inline fun ProtonClient.cancelServiceInstanceDeployment(crossinline block: CancelServiceInstanceDeploymentRequest.Builder.() -> Unit): CancelServiceInstanceDeploymentResponse = cancelServiceInstanceDeployment(CancelServiceInstanceDeploymentRequest.Builder().apply(block).build())

/**
 * Attempts to cancel a service pipeline deployment on an UpdateServicePipeline action, if the deployment is `IN_PROGRESS`. For more information, see *Update a service pipeline* in the [Proton Administrator guide](https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-pipeline-update.html) or the [Proton User guide](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-pipeline-update.html).
 *
 * The following list includes potential cancellation scenarios.
 * + If the cancellation attempt succeeds, the resulting deployment state is `CANCELLED`.
 * + If the cancellation attempt fails, the resulting deployment state is `FAILED`.
 * + If the current UpdateServicePipeline action succeeds before the cancellation attempt starts, the resulting deployment state is `SUCCEEDED` and the cancellation attempt has no effect.
 */
public suspend inline fun ProtonClient.cancelServicePipelineDeployment(crossinline block: CancelServicePipelineDeploymentRequest.Builder.() -> Unit): CancelServicePipelineDeploymentResponse = cancelServicePipelineDeployment(CancelServicePipelineDeploymentRequest.Builder().apply(block).build())

/**
 * Create an Proton component. A component is an infrastructure extension for a service instance.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.
 *
 * **You can provision environments using the following methods:**
 * + Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.
 * + Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as code (IaC) files that your IaC engine uses to provision resources.
 *
 * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.
 *
 * An environment account connection is a secure bi-directional connection between a *management account* and an *environment account* that maintains authorization and permissions. For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.createEnvironmentAccountConnection(crossinline block: CreateEnvironmentAccountConnectionRequest.Builder.() -> Unit): CreateEnvironmentAccountConnectionResponse = createEnvironmentAccountConnection(CreateEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * Create an environment template for Proton. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the *Proton Administrator Guide*.
 *
 * You can create an environment template in one of the two following ways:
 * + Register and publish a *standard* environment template that instructs Proton to deploy and manage environment infrastructure.
 * + Register and publish a *customer managed* environment template that connects Proton to your existing provisioned infrastructure that you manage. Proton *doesn't* manage your existing provisioned infrastructure. To create an environment template for customer provisioned and managed infrastructure, include the `provisioning` parameter and set the value to `CUSTOMER_MANAGED`. For more information, see [Register and publish an environment template](https://docs.aws.amazon.com/proton/latest/adminguide/template-create.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createEnvironmentTemplate(crossinline block: CreateEnvironmentTemplateRequest.Builder.() -> Unit): CreateEnvironmentTemplateResponse = createEnvironmentTemplate(CreateEnvironmentTemplateRequest.Builder().apply(block).build())

/**
 * Create a new major or minor version of an environment template. A major version of an environment template is a version that *isn't* backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.
 */
public suspend inline fun ProtonClient.createEnvironmentTemplateVersion(crossinline block: CreateEnvironmentTemplateVersionRequest.Builder.() -> Unit): CreateEnvironmentTemplateVersionResponse = createEnvironmentTemplateVersion(CreateEnvironmentTemplateVersionRequest.Builder().apply(block).build())

/**
 * Create and register a link to a repository that can be used with self-managed provisioning (infrastructure or pipelines) or for template sync configurations. When you create a repository link, Proton creates a [service-linked role](https://docs.aws.amazon.com/proton/latest/adminguide/using-service-linked-roles.html) for you.
 *
 * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self), [Template bundles](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html), and [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createRepository(crossinline block: CreateRepositoryRequest.Builder.() -> Unit): CreateRepositoryResponse = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

/**
 * Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see [Services](https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html) in the *Proton Administrator Guide* and [Services](https://docs.aws.amazon.com/proton/latest/userguide/ug-service.html) in the *Proton User Guide*.
 */
public suspend inline fun ProtonClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see [Service Templates](https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createServiceTemplate(crossinline block: CreateServiceTemplateRequest.Builder.() -> Unit): CreateServiceTemplateResponse = createServiceTemplate(CreateServiceTemplateRequest.Builder().apply(block).build())

/**
 * Create a new major or minor version of a service template. A major version of a service template is a version that *isn't* backward compatible. A minor version of a service template is a version that's backward compatible within its major version.
 */
public suspend inline fun ProtonClient.createServiceTemplateVersion(crossinline block: CreateServiceTemplateVersionRequest.Builder.() -> Unit): CreateServiceTemplateVersionResponse = createServiceTemplateVersion(CreateServiceTemplateVersionRequest.Builder().apply(block).build())

/**
 * Set up a template to create new template versions automatically. When a commit is pushed to your registered [repository](https://docs.aws.amazon.com/proton/latest/APIReference/API_Repository.html), Proton checks for changes to your repository template bundles. If it detects a template bundle change, a new major or minor version of its template is created, if the version doesn’t already exist. For more information, see [Template sync configurations](https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.createTemplateSyncConfig(crossinline block: CreateTemplateSyncConfigRequest.Builder.() -> Unit): CreateTemplateSyncConfigResponse = createTemplateSyncConfig(CreateTemplateSyncConfigRequest.Builder().apply(block).build())

/**
 * Delete an Proton component resource.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Delete an environment.
 */
public suspend inline fun ProtonClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * In an environment account, delete an environment account connection.
 *
 * After you delete an environment account connection that’s in use by an Proton environment, Proton *can’t* manage the environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment. You're responsible for cleaning up provisioned resources that remain without an environment connection.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.deleteEnvironmentAccountConnection(crossinline block: DeleteEnvironmentAccountConnectionRequest.Builder.() -> Unit): DeleteEnvironmentAccountConnectionResponse = deleteEnvironmentAccountConnection(DeleteEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * If no other major or minor versions of an environment template exist, delete the environment template.
 */
public suspend inline fun ProtonClient.deleteEnvironmentTemplate(crossinline block: DeleteEnvironmentTemplateRequest.Builder.() -> Unit): DeleteEnvironmentTemplateResponse = deleteEnvironmentTemplate(DeleteEnvironmentTemplateRequest.Builder().apply(block).build())

/**
 * If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the `Recommended` version. Delete the `Recommended` version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that's not backward compatible.
 *
 * Delete a minor version of an environment template if it *isn't* the `Recommended` version. Delete a `Recommended` minor version of the environment template if no other minor versions of the environment template exist. A minor version of an environment template is a version that's backward compatible.
 */
public suspend inline fun ProtonClient.deleteEnvironmentTemplateVersion(crossinline block: DeleteEnvironmentTemplateVersionRequest.Builder.() -> Unit): DeleteEnvironmentTemplateVersionResponse = deleteEnvironmentTemplateVersion(DeleteEnvironmentTemplateVersionRequest.Builder().apply(block).build())

/**
 * De-register and unlink your repository.
 */
public suspend inline fun ProtonClient.deleteRepository(crossinline block: DeleteRepositoryRequest.Builder.() -> Unit): DeleteRepositoryResponse = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

/**
 * Delete a service, with its instances and pipeline.
 *
 * You can't delete a service if it has any service instances that have components attached to them.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * If no other major or minor versions of the service template exist, delete the service template.
 */
public suspend inline fun ProtonClient.deleteServiceTemplate(crossinline block: DeleteServiceTemplateRequest.Builder.() -> Unit): DeleteServiceTemplateResponse = deleteServiceTemplate(DeleteServiceTemplateRequest.Builder().apply(block).build())

/**
 * If no other minor versions of a service template exist, delete a major version of the service template if it's not the `Recommended` version. Delete the `Recommended` version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that *isn't* backwards compatible.
 *
 * Delete a minor version of a service template if it's not the `Recommended` version. Delete a `Recommended` minor version of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that's backwards compatible.
 */
public suspend inline fun ProtonClient.deleteServiceTemplateVersion(crossinline block: DeleteServiceTemplateVersionRequest.Builder.() -> Unit): DeleteServiceTemplateVersionResponse = deleteServiceTemplateVersion(DeleteServiceTemplateVersionRequest.Builder().apply(block).build())

/**
 * Delete a template sync configuration.
 */
public suspend inline fun ProtonClient.deleteTemplateSyncConfig(crossinline block: DeleteTemplateSyncConfigRequest.Builder.() -> Unit): DeleteTemplateSyncConfigResponse = deleteTemplateSyncConfig(DeleteTemplateSyncConfigRequest.Builder().apply(block).build())

/**
 * Get detail data for the Proton pipeline service role.
 */
public suspend inline fun ProtonClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Get detailed data for a component.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.getComponent(crossinline block: GetComponentRequest.Builder.() -> Unit): GetComponentResponse = getComponent(GetComponentRequest.Builder().apply(block).build())

/**
 * Get detailed data for an environment.
 */
public suspend inline fun ProtonClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * In an environment account, get the detailed data for an environment account connection.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.getEnvironmentAccountConnection(crossinline block: GetEnvironmentAccountConnectionRequest.Builder.() -> Unit): GetEnvironmentAccountConnectionResponse = getEnvironmentAccountConnection(GetEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * Get detailed data for an environment template.
 */
public suspend inline fun ProtonClient.getEnvironmentTemplate(crossinline block: GetEnvironmentTemplateRequest.Builder.() -> Unit): GetEnvironmentTemplateResponse = getEnvironmentTemplate(GetEnvironmentTemplateRequest.Builder().apply(block).build())

/**
 * Get detailed data for a major or minor version of an environment template.
 */
public suspend inline fun ProtonClient.getEnvironmentTemplateVersion(crossinline block: GetEnvironmentTemplateVersionRequest.Builder.() -> Unit): GetEnvironmentTemplateVersionResponse = getEnvironmentTemplateVersion(GetEnvironmentTemplateVersionRequest.Builder().apply(block).build())

/**
 * Get detail data for a repository.
 */
public suspend inline fun ProtonClient.getRepository(crossinline block: GetRepositoryRequest.Builder.() -> Unit): GetRepositoryResponse = getRepository(GetRepositoryRequest.Builder().apply(block).build())

/**
 * Get the sync status of a repository used for Proton template sync. For more information about template sync, see .
 *
 * A repository sync status isn't tied to the Proton Repository resource (or any other Proton resource). Therefore, tags on an Proton Repository resource have no effect on this action. Specifically, you can't use these tags to control access to this action using Attribute-based access control (ABAC).
 *
 * For more information about ABAC, see [ABAC](https://docs.aws.amazon.com/proton/latest/adminguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.getRepositorySyncStatus(crossinline block: GetRepositorySyncStatusRequest.Builder.() -> Unit): GetRepositorySyncStatusResponse = getRepositorySyncStatus(GetRepositorySyncStatusRequest.Builder().apply(block).build())

/**
 * Get detailed data for a service.
 */
public suspend inline fun ProtonClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Get detailed data for a service instance. A service instance is an instantiation of service template and it runs in a specific environment.
 */
public suspend inline fun ProtonClient.getServiceInstance(crossinline block: GetServiceInstanceRequest.Builder.() -> Unit): GetServiceInstanceResponse = getServiceInstance(GetServiceInstanceRequest.Builder().apply(block).build())

/**
 * Get detailed data for a service template.
 */
public suspend inline fun ProtonClient.getServiceTemplate(crossinline block: GetServiceTemplateRequest.Builder.() -> Unit): GetServiceTemplateResponse = getServiceTemplate(GetServiceTemplateRequest.Builder().apply(block).build())

/**
 * Get detailed data for a major or minor version of a service template.
 */
public suspend inline fun ProtonClient.getServiceTemplateVersion(crossinline block: GetServiceTemplateVersionRequest.Builder.() -> Unit): GetServiceTemplateVersionResponse = getServiceTemplateVersion(GetServiceTemplateVersionRequest.Builder().apply(block).build())

/**
 * Get detail data for a template sync configuration.
 */
public suspend inline fun ProtonClient.getTemplateSyncConfig(crossinline block: GetTemplateSyncConfigRequest.Builder.() -> Unit): GetTemplateSyncConfigResponse = getTemplateSyncConfig(GetTemplateSyncConfigRequest.Builder().apply(block).build())

/**
 * Get the status of a template sync.
 */
public suspend inline fun ProtonClient.getTemplateSyncStatus(crossinline block: GetTemplateSyncStatusRequest.Builder.() -> Unit): GetTemplateSyncStatusResponse = getTemplateSyncStatus(GetTemplateSyncStatusRequest.Builder().apply(block).build())

/**
 * Get a list of component Infrastructure as Code (IaC) outputs.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.listComponentOutputs(crossinline block: ListComponentOutputsRequest.Builder.() -> Unit): ListComponentOutputsResponse = listComponentOutputs(ListComponentOutputsRequest.Builder().apply(block).build())

/**
 * List provisioned resources for a component with details.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.listComponentProvisionedResources(crossinline block: ListComponentProvisionedResourcesRequest.Builder.() -> Unit): ListComponentProvisionedResourcesResponse = listComponentProvisionedResources(ListComponentProvisionedResourcesRequest.Builder().apply(block).build())

/**
 * List components with summary data. You can filter the result list by environment, service, or a single service instance.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * View a list of environment account connections.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.listEnvironmentAccountConnections(crossinline block: ListEnvironmentAccountConnectionsRequest.Builder.() -> Unit): ListEnvironmentAccountConnectionsResponse = listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsRequest.Builder().apply(block).build())

/**
 * List the infrastructure as code outputs for your environment.
 */
public suspend inline fun ProtonClient.listEnvironmentOutputs(crossinline block: ListEnvironmentOutputsRequest.Builder.() -> Unit): ListEnvironmentOutputsResponse = listEnvironmentOutputs(ListEnvironmentOutputsRequest.Builder().apply(block).build())

/**
 * List the provisioned resources for your environment.
 */
public suspend inline fun ProtonClient.listEnvironmentProvisionedResources(crossinline block: ListEnvironmentProvisionedResourcesRequest.Builder.() -> Unit): ListEnvironmentProvisionedResourcesResponse = listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesRequest.Builder().apply(block).build())

/**
 * List major or minor versions of an environment template with detail data.
 */
public suspend inline fun ProtonClient.listEnvironmentTemplateVersions(crossinline block: ListEnvironmentTemplateVersionsRequest.Builder.() -> Unit): ListEnvironmentTemplateVersionsResponse = listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsRequest.Builder().apply(block).build())

/**
 * List environment templates.
 */
public suspend inline fun ProtonClient.listEnvironmentTemplates(crossinline block: ListEnvironmentTemplatesRequest.Builder.() -> Unit): ListEnvironmentTemplatesResponse = listEnvironmentTemplates(ListEnvironmentTemplatesRequest.Builder().apply(block).build())

/**
 * List environments with detail data summaries.
 */
public suspend inline fun ProtonClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * List repositories with detail data.
 */
public suspend inline fun ProtonClient.listRepositories(crossinline block: ListRepositoriesRequest.Builder.() -> Unit): ListRepositoriesResponse = listRepositories(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * List repository sync definitions with detail data.
 */
public suspend inline fun ProtonClient.listRepositorySyncDefinitions(crossinline block: ListRepositorySyncDefinitionsRequest.Builder.() -> Unit): ListRepositorySyncDefinitionsResponse = listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest.Builder().apply(block).build())

/**
 * Get a list service of instance Infrastructure as Code (IaC) outputs.
 */
public suspend inline fun ProtonClient.listServiceInstanceOutputs(crossinline block: ListServiceInstanceOutputsRequest.Builder.() -> Unit): ListServiceInstanceOutputsResponse = listServiceInstanceOutputs(ListServiceInstanceOutputsRequest.Builder().apply(block).build())

/**
 * List provisioned resources for a service instance with details.
 */
public suspend inline fun ProtonClient.listServiceInstanceProvisionedResources(crossinline block: ListServiceInstanceProvisionedResourcesRequest.Builder.() -> Unit): ListServiceInstanceProvisionedResourcesResponse = listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesRequest.Builder().apply(block).build())

/**
 * List service instances with summary data.
 */
public suspend inline fun ProtonClient.listServiceInstances(crossinline block: ListServiceInstancesRequest.Builder.() -> Unit): ListServiceInstancesResponse = listServiceInstances(ListServiceInstancesRequest.Builder().apply(block).build())

/**
 * Get a list of service pipeline Infrastructure as Code (IaC) outputs.
 */
public suspend inline fun ProtonClient.listServicePipelineOutputs(crossinline block: ListServicePipelineOutputsRequest.Builder.() -> Unit): ListServicePipelineOutputsResponse = listServicePipelineOutputs(ListServicePipelineOutputsRequest.Builder().apply(block).build())

/**
 * List provisioned resources for a service and pipeline with details.
 */
public suspend inline fun ProtonClient.listServicePipelineProvisionedResources(crossinline block: ListServicePipelineProvisionedResourcesRequest.Builder.() -> Unit): ListServicePipelineProvisionedResourcesResponse = listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesRequest.Builder().apply(block).build())

/**
 * List major or minor versions of a service template with detail data.
 */
public suspend inline fun ProtonClient.listServiceTemplateVersions(crossinline block: ListServiceTemplateVersionsRequest.Builder.() -> Unit): ListServiceTemplateVersionsResponse = listServiceTemplateVersions(ListServiceTemplateVersionsRequest.Builder().apply(block).build())

/**
 * List service templates with detail data.
 */
public suspend inline fun ProtonClient.listServiceTemplates(crossinline block: ListServiceTemplatesRequest.Builder.() -> Unit): ListServiceTemplatesResponse = listServiceTemplates(ListServiceTemplatesRequest.Builder().apply(block).build())

/**
 * List services with summaries of detail data.
 */
public suspend inline fun ProtonClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * List tags for a resource. For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
 */
public suspend inline fun ProtonClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.
 *
 * For more information, see [Self-managed provisioning](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.notifyResourceDeploymentStatusChange(crossinline block: NotifyResourceDeploymentStatusChangeRequest.Builder.() -> Unit): NotifyResourceDeploymentStatusChangeResponse = notifyResourceDeploymentStatusChange(NotifyResourceDeploymentStatusChangeRequest.Builder().apply(block).build())

/**
 * In a management account, reject an environment account connection from another environment account.
 *
 * After you reject an environment account connection request, you *can't* accept or use the rejected environment account connection.
 *
 * You *can’t* reject an environment account connection that's connected to an environment.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.rejectEnvironmentAccountConnection(crossinline block: RejectEnvironmentAccountConnectionRequest.Builder.() -> Unit): RejectEnvironmentAccountConnectionResponse = rejectEnvironmentAccountConnection(RejectEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.
 *
 * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
 */
public suspend inline fun ProtonClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.
 *
 * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
 */
public suspend inline fun ProtonClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the Proton service pipeline role or repository settings.
 */
public suspend inline fun ProtonClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Update a component.
 *
 * There are a few modes for updating a component. The `deploymentType` field defines the mode.
 *
 * You can't update a component while its deployment status, or the deployment status of a service instance attached to it, is `IN_PROGRESS`.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.updateComponent(crossinline block: UpdateComponentRequest.Builder.() -> Unit): UpdateComponentResponse = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

/**
 * Update an environment.
 *
 * If the environment is associated with an environment account connection, *don't* update or include the `protonServiceRoleArn` and `provisioningRepository` parameter to update or connect to an environment account connection.
 *
 * You can only update to a new environment account connection if that connection was created in the same environment account that the current environment account connection was created in. The account connection must also be associated with the current environment.
 *
 * If the environment *isn't* associated with an environment account connection, *don't* update or include the `environmentAccountConnectionId` parameter. You *can't* update or connect the environment to an environment account connection if it *isn't* already associated with an environment connection.
 *
 * You can update either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and value. You can’t update both.
 *
 * If the environment was configured for Amazon Web Services-managed provisioning, omit the `provisioningRepository` parameter.
 *
 * If the environment was configured for self-managed provisioning, specify the `provisioningRepository` parameter and omit the `protonServiceRoleArn` and `environmentAccountConnectionId` parameters.
 *
 * For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) and [Provisioning methods](https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html) in the *Proton Administrator Guide*.
 *
 * There are four modes for updating an environment. The `deploymentType` field defines the mode.
 *
 * `NONE`
 *
 * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
 *
 * `CURRENT_VERSION`
 *
 * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include minor or major version parameters when you use this `deployment-type`.
 *
 * `MINOR_VERSION`
 *
 * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
 *
 * `MAJOR_VERSION`
 *
 * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that's higher than the major version in use and a minor version.
 */
public suspend inline fun ProtonClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * In an environment account, update an environment account connection to use a new IAM role.
 *
 * For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
 */
public suspend inline fun ProtonClient.updateEnvironmentAccountConnection(crossinline block: UpdateEnvironmentAccountConnectionRequest.Builder.() -> Unit): UpdateEnvironmentAccountConnectionResponse = updateEnvironmentAccountConnection(UpdateEnvironmentAccountConnectionRequest.Builder().apply(block).build())

/**
 * Update an environment template.
 */
public suspend inline fun ProtonClient.updateEnvironmentTemplate(crossinline block: UpdateEnvironmentTemplateRequest.Builder.() -> Unit): UpdateEnvironmentTemplateResponse = updateEnvironmentTemplate(UpdateEnvironmentTemplateRequest.Builder().apply(block).build())

/**
 * Update a major or minor version of an environment template.
 */
public suspend inline fun ProtonClient.updateEnvironmentTemplateVersion(crossinline block: UpdateEnvironmentTemplateVersionRequest.Builder.() -> Unit): UpdateEnvironmentTemplateVersionResponse = updateEnvironmentTemplateVersion(UpdateEnvironmentTemplateVersionRequest.Builder().apply(block).build())

/**
 * Edit a service description or use a spec to add and delete service instances.
 *
 * Existing service instances and the service pipeline *can't* be edited using this API. They can only be deleted.
 *
 * Use the `description` parameter to modify the description.
 *
 * Edit the `spec` parameter to add or delete instances.
 *
 * You can't delete a service instance (remove it from the spec) if it has an attached component.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())

/**
 * Update a service instance.
 *
 * There are a few modes for updating a service instance. The `deploymentType` field defines the mode.
 *
 * You can't update a service instance while its deployment status, or the deployment status of a component attached to it, is `IN_PROGRESS`.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public suspend inline fun ProtonClient.updateServiceInstance(crossinline block: UpdateServiceInstanceRequest.Builder.() -> Unit): UpdateServiceInstanceResponse = updateServiceInstance(UpdateServiceInstanceRequest.Builder().apply(block).build())

/**
 * Update the service pipeline.
 *
 * There are four modes for updating a service pipeline. The `deploymentType` field defines the mode.
 *
 * `NONE`
 *
 * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
 *
 * `CURRENT_VERSION`
 *
 * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
 *
 * `MINOR_VERSION`
 *
 * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.
 *
 * `MAJOR_VERSION`
 *
 * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template by default. You can specify a different major version that's higher than the major version in use and a minor version.
 */
public suspend inline fun ProtonClient.updateServicePipeline(crossinline block: UpdateServicePipelineRequest.Builder.() -> Unit): UpdateServicePipelineResponse = updateServicePipeline(UpdateServicePipelineRequest.Builder().apply(block).build())

/**
 * Update a service template.
 */
public suspend inline fun ProtonClient.updateServiceTemplate(crossinline block: UpdateServiceTemplateRequest.Builder.() -> Unit): UpdateServiceTemplateResponse = updateServiceTemplate(UpdateServiceTemplateRequest.Builder().apply(block).build())

/**
 * Update a major or minor version of a service template.
 */
public suspend inline fun ProtonClient.updateServiceTemplateVersion(crossinline block: UpdateServiceTemplateVersionRequest.Builder.() -> Unit): UpdateServiceTemplateVersionResponse = updateServiceTemplateVersion(UpdateServiceTemplateVersionRequest.Builder().apply(block).build())

/**
 * Update template sync configuration parameters, except for the `templateName` and `templateType`.
 */
public suspend inline fun ProtonClient.updateTemplateSyncConfig(crossinline block: UpdateTemplateSyncConfigRequest.Builder.() -> Unit): UpdateTemplateSyncConfigResponse = updateTemplateSyncConfig(UpdateTemplateSyncConfigRequest.Builder().apply(block).build())
