// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



/**
 * The Proton pipeline service role and repository data shared across the Amazon Web Services account.
 */
public class AccountSettings private constructor(builder: Builder) {
    /**
     * The repository configured in the Amazon Web Services account for pipeline provisioning. Required it if you have environments configured for self-managed provisioning with services that include pipelines.
     */
    public val pipelineProvisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranch? = builder.pipelineProvisioningRepository
    /**
     * The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed provisioning.
     */
    public val pipelineServiceRoleArn: kotlin.String? = builder.pipelineServiceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.AccountSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountSettings(")
        append("pipelineProvisioningRepository=$pipelineProvisioningRepository,")
        append("pipelineServiceRoleArn=$pipelineServiceRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pipelineProvisioningRepository?.hashCode() ?: 0
        result = 31 * result + (pipelineServiceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountSettings

        if (pipelineProvisioningRepository != other.pipelineProvisioningRepository) return false
        if (pipelineServiceRoleArn != other.pipelineServiceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.AccountSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The repository configured in the Amazon Web Services account for pipeline provisioning. Required it if you have environments configured for self-managed provisioning with services that include pipelines.
         */
        public var pipelineProvisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranch? = null
        /**
         * The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed provisioning.
         */
        public var pipelineServiceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.AccountSettings) : this() {
            this.pipelineProvisioningRepository = x.pipelineProvisioningRepository
            this.pipelineServiceRoleArn = x.pipelineServiceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.AccountSettings = AccountSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.proton.model.RepositoryBranch] inside the given [block]
         */
        public fun pipelineProvisioningRepository(block: aws.sdk.kotlin.services.proton.model.RepositoryBranch.Builder.() -> kotlin.Unit) {
            this.pipelineProvisioningRepository = aws.sdk.kotlin.services.proton.model.RepositoryBranch.invoke(block)
        }
    }
}
