// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed data of an Proton component resource.
 *
 * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
 */
public class Component private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the component was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The component deployment status.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * The message associated with the component deployment status.
     */
    public val deploymentStatusMessage: kotlin.String? = builder.deploymentStatusMessage
    /**
     * A description of the component.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the Proton environment that this component is associated with.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The time when a deployment of the component was last attempted.
     */
    public val lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentAttemptedAt
    /**
     * The time when the component was last deployed successfully.
     */
    public val lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentSucceededAt
    /**
     * The time when the component was last modified.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the service instance that this component is attached to. Provided when a component is attached to a service instance.
     */
    public val serviceInstanceName: kotlin.String? = builder.serviceInstanceName
    /**
     * The name of the service that `serviceInstanceName` is associated with. Provided when a component is attached to a service instance.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The service spec that the component uses to access service inputs. Provided when a component is attached to a service instance.
     */
    public val serviceSpec: kotlin.String? = builder.serviceSpec

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.Component = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Component(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deploymentStatus=$deploymentStatus,")
        append("deploymentStatusMessage=*** Sensitive Data Redacted ***,")
        append("description=*** Sensitive Data Redacted ***,")
        append("environmentName=$environmentName,")
        append("lastDeploymentAttemptedAt=$lastDeploymentAttemptedAt,")
        append("lastDeploymentSucceededAt=$lastDeploymentSucceededAt,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("name=$name,")
        append("serviceInstanceName=$serviceInstanceName,")
        append("serviceName=$serviceName,")
        append("serviceSpec=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentAttemptedAt?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentSucceededAt?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceInstanceName?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceSpec?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Component

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (deploymentStatusMessage != other.deploymentStatusMessage) return false
        if (description != other.description) return false
        if (environmentName != other.environmentName) return false
        if (lastDeploymentAttemptedAt != other.lastDeploymentAttemptedAt) return false
        if (lastDeploymentSucceededAt != other.lastDeploymentSucceededAt) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (name != other.name) return false
        if (serviceInstanceName != other.serviceInstanceName) return false
        if (serviceName != other.serviceName) return false
        if (serviceSpec != other.serviceSpec) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.Component = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the component was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The component deployment status.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = null
        /**
         * The message associated with the component deployment status.
         */
        public var deploymentStatusMessage: kotlin.String? = null
        /**
         * A description of the component.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the Proton environment that this component is associated with.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The time when a deployment of the component was last attempted.
         */
        public var lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the component was last deployed successfully.
         */
        public var lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the component was last modified.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the service instance that this component is attached to. Provided when a component is attached to a service instance.
         */
        public var serviceInstanceName: kotlin.String? = null
        /**
         * The name of the service that `serviceInstanceName` is associated with. Provided when a component is attached to a service instance.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The service spec that the component uses to access service inputs. Provided when a component is attached to a service instance.
         */
        public var serviceSpec: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.Component) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deploymentStatus = x.deploymentStatus
            this.deploymentStatusMessage = x.deploymentStatusMessage
            this.description = x.description
            this.environmentName = x.environmentName
            this.lastDeploymentAttemptedAt = x.lastDeploymentAttemptedAt
            this.lastDeploymentSucceededAt = x.lastDeploymentSucceededAt
            this.lastModifiedAt = x.lastModifiedAt
            this.name = x.name
            this.serviceInstanceName = x.serviceInstanceName
            this.serviceName = x.serviceName
            this.serviceSpec = x.serviceSpec
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.Component = Component(this)
    }
}
