// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class CreateComponentRequest private constructor(builder: Builder) {
    /**
     * An optional customer-provided description of the component.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the Proton environment that you want to associate this component with. You must specify this when you don't specify `serviceInstanceName` and `serviceName`.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and rendering engine for infrastructure that a custom component provisions.
     */
    public val manifest: kotlin.String? = builder.manifest
    /**
     * The customer-provided name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the service instance that you want to attach this component to. If you don't specify this, the component isn't attached to any service instance. Specify both `serviceInstanceName` and `serviceName` or neither of them.
     */
    public val serviceInstanceName: kotlin.String? = builder.serviceInstanceName
    /**
     * The name of the service that `serviceInstanceName` is associated with. If you don't specify this, the component isn't attached to any service instance. Specify both `serviceInstanceName` and `serviceName` or neither of them.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The service spec that you want the component to use to access service inputs. Set this only when you attach the component to a service instance.
     */
    public val serviceSpec: kotlin.String? = builder.serviceSpec
    /**
     * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value pair.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
     *
     * Components support a single IaC file, even if you use Terraform as your template language.
     */
    public val templateFile: kotlin.String? = builder.templateFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.CreateComponentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentRequest(")
        append("description=*** Sensitive Data Redacted ***,")
        append("environmentName=$environmentName,")
        append("manifest=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("serviceInstanceName=$serviceInstanceName,")
        append("serviceName=$serviceName,")
        append("serviceSpec=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("templateFile=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (manifest?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceInstanceName?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceSpec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateFile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComponentRequest

        if (description != other.description) return false
        if (environmentName != other.environmentName) return false
        if (manifest != other.manifest) return false
        if (name != other.name) return false
        if (serviceInstanceName != other.serviceInstanceName) return false
        if (serviceName != other.serviceName) return false
        if (serviceSpec != other.serviceSpec) return false
        if (tags != other.tags) return false
        if (templateFile != other.templateFile) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.CreateComponentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional customer-provided description of the component.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the Proton environment that you want to associate this component with. You must specify this when you don't specify `serviceInstanceName` and `serviceName`.
         */
        public var environmentName: kotlin.String? = null
        /**
         * A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and rendering engine for infrastructure that a custom component provisions.
         */
        public var manifest: kotlin.String? = null
        /**
         * The customer-provided name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the service instance that you want to attach this component to. If you don't specify this, the component isn't attached to any service instance. Specify both `serviceInstanceName` and `serviceName` or neither of them.
         */
        public var serviceInstanceName: kotlin.String? = null
        /**
         * The name of the service that `serviceInstanceName` is associated with. If you don't specify this, the component isn't attached to any service instance. Specify both `serviceInstanceName` and `serviceName` or neither of them.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The service spec that you want the component to use to access service inputs. Set this only when you attach the component to a service instance.
         */
        public var serviceSpec: kotlin.String? = null
        /**
         * An optional list of metadata items that you can associate with the Proton component. A tag is a key-value pair.
         *
         * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
         */
        public var tags: List<Tag>? = null
        /**
         * A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.
         *
         * Components support a single IaC file, even if you use Terraform as your template language.
         */
        public var templateFile: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.CreateComponentRequest) : this() {
            this.description = x.description
            this.environmentName = x.environmentName
            this.manifest = x.manifest
            this.name = x.name
            this.serviceInstanceName = x.serviceInstanceName
            this.serviceName = x.serviceName
            this.serviceSpec = x.serviceSpec
            this.tags = x.tags
            this.templateFile = x.templateFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.CreateComponentRequest = CreateComponentRequest(this)
    }
}
