// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class CreateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
     *
     * You must specify `componentRoleArn` to allow directly defined components to be associated with this environment.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val componentRoleArn: kotlin.String? = builder.componentRoleArn
    /**
     * A description of the environment that's being created and deployed.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an environment account. For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
     *
     * To use Amazon Web Services-managed provisioning for the environment, specify either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and omit the `provisioningRepository` parameter.
     */
    public val environmentAccountConnectionId: kotlin.String? = builder.environmentAccountConnectionId
    /**
     * The name of the environment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.
     *
     * To use Amazon Web Services-managed provisioning for the environment, specify either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and omit the `provisioningRepository` parameter.
     */
    public val protonServiceRoleArn: kotlin.String? = builder.protonServiceRoleArn
    /**
     * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
     *
     * To use self-managed provisioning for the environment, specify this parameter and omit the `environmentAccountConnectionId` and `protonServiceRoleArn` parameters.
     */
    public val provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput? = builder.provisioningRepository
    /**
     * A YAML formatted string that provides inputs as defined in the environment template bundle schema file. For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) in the *Proton Administrator Guide*.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value pair.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The major version of the environment template.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the environment template.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion
    /**
     * The name of the environment template. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the *Proton Administrator Guide*.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.CreateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentRequest(")
        append("componentRoleArn=$componentRoleArn,")
        append("description=*** Sensitive Data Redacted ***,")
        append("environmentAccountConnectionId=$environmentAccountConnectionId,")
        append("name=$name,")
        append("protonServiceRoleArn=$protonServiceRoleArn,")
        append("provisioningRepository=$provisioningRepository,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentRoleArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentAccountConnectionId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protonServiceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (provisioningRepository?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentRequest

        if (componentRoleArn != other.componentRoleArn) return false
        if (description != other.description) return false
        if (environmentAccountConnectionId != other.environmentAccountConnectionId) return false
        if (name != other.name) return false
        if (protonServiceRoleArn != other.protonServiceRoleArn) return false
        if (provisioningRepository != other.provisioningRepository) return false
        if (spec != other.spec) return false
        if (tags != other.tags) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.CreateEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
         *
         * You must specify `componentRoleArn` to allow directly defined components to be associated with this environment.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var componentRoleArn: kotlin.String? = null
        /**
         * A description of the environment that's being created and deployed.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an environment account. For more information, see [Environment account connections](https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html) in the *Proton Administrator guide*.
         *
         * To use Amazon Web Services-managed provisioning for the environment, specify either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and omit the `provisioningRepository` parameter.
         */
        public var environmentAccountConnectionId: kotlin.String? = null
        /**
         * The name of the environment.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.
         *
         * To use Amazon Web Services-managed provisioning for the environment, specify either the `environmentAccountConnectionId` or `protonServiceRoleArn` parameter and omit the `provisioningRepository` parameter.
         */
        public var protonServiceRoleArn: kotlin.String? = null
        /**
         * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
         *
         * To use self-managed provisioning for the environment, specify this parameter and omit the `environmentAccountConnectionId` and `protonServiceRoleArn` parameters.
         */
        public var provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput? = null
        /**
         * A YAML formatted string that provides inputs as defined in the environment template bundle schema file. For more information, see [Environments](https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) in the *Proton Administrator Guide*.
         */
        public var spec: kotlin.String? = null
        /**
         * An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value pair.
         *
         * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The major version of the environment template.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the environment template.
         */
        public var templateMinorVersion: kotlin.String? = null
        /**
         * The name of the environment template. For more information, see [Environment Templates](https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the *Proton Administrator Guide*.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.CreateEnvironmentRequest) : this() {
            this.componentRoleArn = x.componentRoleArn
            this.description = x.description
            this.environmentAccountConnectionId = x.environmentAccountConnectionId
            this.name = x.name
            this.protonServiceRoleArn = x.protonServiceRoleArn
            this.provisioningRepository = x.provisioningRepository
            this.spec = x.spec
            this.tags = x.tags
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.CreateEnvironmentRequest = CreateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.proton.model.RepositoryBranchInput] inside the given [block]
         */
        public fun provisioningRepository(block: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput.Builder.() -> kotlin.Unit) {
            this.provisioningRepository = aws.sdk.kotlin.services.proton.model.RepositoryBranchInput.invoke(block)
        }
    }
}
