// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class CreateEnvironmentTemplateVersionRequest private constructor(builder: Builder) {
    /**
     * When included, if two identical requests are made with the same client token, Proton returns the environment template version that the first request created.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description of the new version of an environment template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * To create a new minor version of the environment template, include `major Version`.
     *
     * To create a new major and minor version of the environment template, exclude `major Version`.
     */
    public val majorVersion: kotlin.String? = builder.majorVersion
    /**
     * An object that includes the template bundle S3 bucket path and name for the new version of an template.
     */
    public val source: aws.sdk.kotlin.services.proton.model.TemplateVersionSourceInput? = builder.source
    /**
     * An optional list of metadata items that you can associate with the Proton environment template version. A tag is a key-value pair.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the environment template.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentTemplateVersionRequest(")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("majorVersion=$majorVersion,")
        append("source=$source,")
        append("tags=$tags,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (majorVersion?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentTemplateVersionRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (majorVersion != other.majorVersion) return false
        if (source != other.source) return false
        if (tags != other.tags) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When included, if two identical requests are made with the same client token, Proton returns the environment template version that the first request created.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description of the new version of an environment template.
         */
        public var description: kotlin.String? = null
        /**
         * To create a new minor version of the environment template, include `major Version`.
         *
         * To create a new major and minor version of the environment template, exclude `major Version`.
         */
        public var majorVersion: kotlin.String? = null
        /**
         * An object that includes the template bundle S3 bucket path and name for the new version of an template.
         */
        public var source: aws.sdk.kotlin.services.proton.model.TemplateVersionSourceInput? = null
        /**
         * An optional list of metadata items that you can associate with the Proton environment template version. A tag is a key-value pair.
         *
         * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the environment template.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.majorVersion = x.majorVersion
            this.source = x.source
            this.tags = x.tags
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.CreateEnvironmentTemplateVersionRequest = CreateEnvironmentTemplateVersionRequest(this)
    }
}
