// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * The name of the code repository branch that holds the code that's deployed in Proton. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * A description of the Proton service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The service name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the repository connection. For more information, see [Set up repository connection](https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol) in the *Proton Administrator Guide* and [Setting up with Proton](https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection) in the *Proton User Guide*. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
     */
    public val repositoryConnectionArn: kotlin.String? = builder.repositoryConnectionArn
    /**
     * The ID of the code repository. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
     */
    public val repositoryId: kotlin.String? = builder.repositoryId
    /**
     * A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. *Don’t* include pipeline inputs in the spec if your service template *doesn’t* include a service pipeline. For more information, see [Create a service](https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html) in the *Proton Administrator Guide* and [Create a service](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html) in the *Proton User Guide*.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * An optional list of metadata items that you can associate with the Proton service. A tag is a key-value pair.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The major version of the service template that was used to create the service.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the service template that was used to create the service.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion
    /**
     * The name of the service template that's used to create the service.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("branchName=$branchName,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("repositoryConnectionArn=$repositoryConnectionArn,")
        append("repositoryId=$repositoryId,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (repositoryConnectionArn?.hashCode() ?: 0)
        result = 31 * result + (repositoryId?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (branchName != other.branchName) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (repositoryConnectionArn != other.repositoryConnectionArn) return false
        if (repositoryId != other.repositoryId) return false
        if (spec != other.spec) return false
        if (tags != other.tags) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.CreateServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the code repository branch that holds the code that's deployed in Proton. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
         */
        public var branchName: kotlin.String? = null
        /**
         * A description of the Proton service.
         */
        public var description: kotlin.String? = null
        /**
         * The service name.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the repository connection. For more information, see [Set up repository connection](https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol) in the *Proton Administrator Guide* and [Setting up with Proton](https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection) in the *Proton User Guide*. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
         */
        public var repositoryConnectionArn: kotlin.String? = null
        /**
         * The ID of the code repository. *Don't* include this parameter if your service template *doesn't* include a service pipeline.
         */
        public var repositoryId: kotlin.String? = null
        /**
         * A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. *Don’t* include pipeline inputs in the spec if your service template *doesn’t* include a service pipeline. For more information, see [Create a service](https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html) in the *Proton Administrator Guide* and [Create a service](https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html) in the *Proton User Guide*.
         */
        public var spec: kotlin.String? = null
        /**
         * An optional list of metadata items that you can associate with the Proton service. A tag is a key-value pair.
         *
         * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The major version of the service template that was used to create the service.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the service template that was used to create the service.
         */
        public var templateMinorVersion: kotlin.String? = null
        /**
         * The name of the service template that's used to create the service.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.CreateServiceRequest) : this() {
            this.branchName = x.branchName
            this.description = x.description
            this.name = x.name
            this.repositoryConnectionArn = x.repositoryConnectionArn
            this.repositoryId = x.repositoryId
            this.spec = x.spec
            this.tags = x.tags
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.CreateServiceRequest = CreateServiceRequest(this)
    }
}
