// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class CreateServiceTemplateVersionRequest private constructor(builder: Builder) {
    /**
     * When included, if two identical requests are made with the same client token, Proton returns the service template version that the first request created.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * An array of environment template objects that are compatible with the new service template version. A service instance based on this service template version can run in environments based on compatible templates.
     */
    public val compatibleEnvironmentTemplates: List<CompatibleEnvironmentTemplateInput>? = builder.compatibleEnvironmentTemplates
    /**
     * A description of the new version of a service template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * To create a new minor version of the service template, include a `major Version`.
     *
     * To create a new major and minor version of the service template, *exclude*`major Version`.
     */
    public val majorVersion: kotlin.String? = builder.majorVersion
    /**
     * An object that includes the template bundle S3 bucket path and name for the new version of a service template.
     */
    public val source: aws.sdk.kotlin.services.proton.model.TemplateVersionSourceInput? = builder.source
    /**
     * An array of supported component sources. Components with supported sources can be attached to service instances based on this service template version.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val supportedComponentSources: List<ServiceTemplateSupportedComponentSourceType>? = builder.supportedComponentSources
    /**
     * An optional list of metadata items that you can associate with the Proton service template version. A tag is a key-value pair.
     *
     * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the service template.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceTemplateVersionRequest(")
        append("clientToken=$clientToken,")
        append("compatibleEnvironmentTemplates=$compatibleEnvironmentTemplates,")
        append("description=*** Sensitive Data Redacted ***,")
        append("majorVersion=$majorVersion,")
        append("source=$source,")
        append("supportedComponentSources=$supportedComponentSources,")
        append("tags=$tags,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (compatibleEnvironmentTemplates?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (majorVersion?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (supportedComponentSources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceTemplateVersionRequest

        if (clientToken != other.clientToken) return false
        if (compatibleEnvironmentTemplates != other.compatibleEnvironmentTemplates) return false
        if (description != other.description) return false
        if (majorVersion != other.majorVersion) return false
        if (source != other.source) return false
        if (supportedComponentSources != other.supportedComponentSources) return false
        if (tags != other.tags) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When included, if two identical requests are made with the same client token, Proton returns the service template version that the first request created.
         */
        public var clientToken: kotlin.String? = null
        /**
         * An array of environment template objects that are compatible with the new service template version. A service instance based on this service template version can run in environments based on compatible templates.
         */
        public var compatibleEnvironmentTemplates: List<CompatibleEnvironmentTemplateInput>? = null
        /**
         * A description of the new version of a service template.
         */
        public var description: kotlin.String? = null
        /**
         * To create a new minor version of the service template, include a `major Version`.
         *
         * To create a new major and minor version of the service template, *exclude*`major Version`.
         */
        public var majorVersion: kotlin.String? = null
        /**
         * An object that includes the template bundle S3 bucket path and name for the new version of a service template.
         */
        public var source: aws.sdk.kotlin.services.proton.model.TemplateVersionSourceInput? = null
        /**
         * An array of supported component sources. Components with supported sources can be attached to service instances based on this service template version.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var supportedComponentSources: List<ServiceTemplateSupportedComponentSourceType>? = null
        /**
         * An optional list of metadata items that you can associate with the Proton service template version. A tag is a key-value pair.
         *
         * For more information, see *Proton resources and tagging* in the [Proton Administrator Guide](https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or [Proton User Guide](https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the service template.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionRequest) : this() {
            this.clientToken = x.clientToken
            this.compatibleEnvironmentTemplates = x.compatibleEnvironmentTemplates
            this.description = x.description
            this.majorVersion = x.majorVersion
            this.source = x.source
            this.supportedComponentSources = x.supportedComponentSources
            this.tags = x.tags
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.CreateServiceTemplateVersionRequest = CreateServiceTemplateVersionRequest(this)
    }
}
