// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed data of an Proton environment resource. An Proton environment is a set of resources shared across Proton services.
 */
public class Environment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
     *
     * The environment must have a `componentRoleArn` to allow directly defined components to be associated with the environment.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val componentRoleArn: kotlin.String? = builder.componentRoleArn
    /**
     * The time when the environment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The environment deployment status.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * An environment deployment status message.
     */
    public val deploymentStatusMessage: kotlin.String? = builder.deploymentStatusMessage
    /**
     * The description of the environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the environment account connection that's used to provision infrastructure resources in an environment account.
     */
    public val environmentAccountConnectionId: kotlin.String? = builder.environmentAccountConnectionId
    /**
     * The ID of the environment account that the environment infrastructure resources are provisioned in.
     */
    public val environmentAccountId: kotlin.String? = builder.environmentAccountId
    /**
     * The time when a deployment of the environment was last attempted.
     */
    public val lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentAttemptedAt
    /**
     * The time when the environment was last deployed successfully.
     */
    public val lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentSucceededAt
    /**
     * The name of the environment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.
     */
    public val protonServiceRoleArn: kotlin.String? = builder.protonServiceRoleArn
    /**
     * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
     */
    public val provisioning: aws.sdk.kotlin.services.proton.model.Provisioning? = builder.provisioning
    /**
     * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
     */
    public val provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranch? = builder.provisioningRepository
    /**
     * The environment spec.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The major version of the environment template.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the environment template.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion
    /**
     * The Amazon Resource Name (ARN) of the environment template.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.Environment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("arn=$arn,")
        append("componentRoleArn=$componentRoleArn,")
        append("createdAt=$createdAt,")
        append("deploymentStatus=$deploymentStatus,")
        append("deploymentStatusMessage=*** Sensitive Data Redacted ***,")
        append("description=*** Sensitive Data Redacted ***,")
        append("environmentAccountConnectionId=$environmentAccountConnectionId,")
        append("environmentAccountId=$environmentAccountId,")
        append("lastDeploymentAttemptedAt=$lastDeploymentAttemptedAt,")
        append("lastDeploymentSucceededAt=$lastDeploymentSucceededAt,")
        append("name=$name,")
        append("protonServiceRoleArn=$protonServiceRoleArn,")
        append("provisioning=$provisioning,")
        append("provisioningRepository=$provisioningRepository,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentRoleArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentAccountConnectionId?.hashCode() ?: 0)
        result = 31 * result + (environmentAccountId?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentAttemptedAt?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentSucceededAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protonServiceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (provisioning?.hashCode() ?: 0)
        result = 31 * result + (provisioningRepository?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Environment

        if (arn != other.arn) return false
        if (componentRoleArn != other.componentRoleArn) return false
        if (createdAt != other.createdAt) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (deploymentStatusMessage != other.deploymentStatusMessage) return false
        if (description != other.description) return false
        if (environmentAccountConnectionId != other.environmentAccountConnectionId) return false
        if (environmentAccountId != other.environmentAccountId) return false
        if (lastDeploymentAttemptedAt != other.lastDeploymentAttemptedAt) return false
        if (lastDeploymentSucceededAt != other.lastDeploymentSucceededAt) return false
        if (name != other.name) return false
        if (protonServiceRoleArn != other.protonServiceRoleArn) return false
        if (provisioning != other.provisioning) return false
        if (provisioningRepository != other.provisioningRepository) return false
        if (spec != other.spec) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.Environment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
         *
         * The environment must have a `componentRoleArn` to allow directly defined components to be associated with the environment.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var componentRoleArn: kotlin.String? = null
        /**
         * The time when the environment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment deployment status.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = null
        /**
         * An environment deployment status message.
         */
        public var deploymentStatusMessage: kotlin.String? = null
        /**
         * The description of the environment.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the environment account connection that's used to provision infrastructure resources in an environment account.
         */
        public var environmentAccountConnectionId: kotlin.String? = null
        /**
         * The ID of the environment account that the environment infrastructure resources are provisioned in.
         */
        public var environmentAccountId: kotlin.String? = null
        /**
         * The time when a deployment of the environment was last attempted.
         */
        public var lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the environment was last deployed successfully.
         */
        public var lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the environment.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.
         */
        public var protonServiceRoleArn: kotlin.String? = null
        /**
         * When included, indicates that the environment template is for customer provisioned and managed infrastructure.
         */
        public var provisioning: aws.sdk.kotlin.services.proton.model.Provisioning? = null
        /**
         * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
         */
        public var provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranch? = null
        /**
         * The environment spec.
         */
        public var spec: kotlin.String? = null
        /**
         * The major version of the environment template.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the environment template.
         */
        public var templateMinorVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the environment template.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.Environment) : this() {
            this.arn = x.arn
            this.componentRoleArn = x.componentRoleArn
            this.createdAt = x.createdAt
            this.deploymentStatus = x.deploymentStatus
            this.deploymentStatusMessage = x.deploymentStatusMessage
            this.description = x.description
            this.environmentAccountConnectionId = x.environmentAccountConnectionId
            this.environmentAccountId = x.environmentAccountId
            this.lastDeploymentAttemptedAt = x.lastDeploymentAttemptedAt
            this.lastDeploymentSucceededAt = x.lastDeploymentSucceededAt
            this.name = x.name
            this.protonServiceRoleArn = x.protonServiceRoleArn
            this.provisioning = x.provisioning
            this.provisioningRepository = x.provisioningRepository
            this.spec = x.spec
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.Environment = Environment(this)

        /**
         * construct an [aws.sdk.kotlin.services.proton.model.RepositoryBranch] inside the given [block]
         */
        public fun provisioningRepository(block: aws.sdk.kotlin.services.proton.model.RepositoryBranch.Builder.() -> kotlin.Unit) {
            this.provisioningRepository = aws.sdk.kotlin.services.proton.model.RepositoryBranch.invoke(block)
        }
    }
}
