// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed data of an Proton environment account connection resource.
 */
public class EnvironmentAccountConnection private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the environment account connection.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
     *
     * The environment account connection must have a `componentRoleArn` to allow directly defined components to be associated with any environments running in the account.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val componentRoleArn: kotlin.String? = builder.componentRoleArn
    /**
     * The environment account that's connected to the environment account connection.
     */
    public val environmentAccountId: kotlin.String? = builder.environmentAccountId
    /**
     * The name of the environment that's associated with the environment account connection.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The ID of the environment account connection.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time when the environment account connection was last modified.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The ID of the management account that's connected to the environment account connection.
     */
    public val managementAccountId: kotlin.String? = builder.managementAccountId
    /**
     * The time when the environment account connection request was made.
     */
    public val requestedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedAt
    /**
     * The IAM service role that's associated with the environment account connection.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the environment account connection.
     */
    public val status: aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnectionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentAccountConnection(")
        append("arn=$arn,")
        append("componentRoleArn=$componentRoleArn,")
        append("environmentAccountId=$environmentAccountId,")
        append("environmentName=$environmentName,")
        append("id=$id,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("managementAccountId=$managementAccountId,")
        append("requestedAt=$requestedAt,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentRoleArn?.hashCode() ?: 0)
        result = 31 * result + (environmentAccountId?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (managementAccountId?.hashCode() ?: 0)
        result = 31 * result + (requestedAt?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentAccountConnection

        if (arn != other.arn) return false
        if (componentRoleArn != other.componentRoleArn) return false
        if (environmentAccountId != other.environmentAccountId) return false
        if (environmentName != other.environmentName) return false
        if (id != other.id) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (managementAccountId != other.managementAccountId) return false
        if (requestedAt != other.requestedAt) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the environment account connection.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
         *
         * The environment account connection must have a `componentRoleArn` to allow directly defined components to be associated with any environments running in the account.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var componentRoleArn: kotlin.String? = null
        /**
         * The environment account that's connected to the environment account connection.
         */
        public var environmentAccountId: kotlin.String? = null
        /**
         * The name of the environment that's associated with the environment account connection.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The ID of the environment account connection.
         */
        public var id: kotlin.String? = null
        /**
         * The time when the environment account connection was last modified.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the management account that's connected to the environment account connection.
         */
        public var managementAccountId: kotlin.String? = null
        /**
         * The time when the environment account connection request was made.
         */
        public var requestedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM service role that's associated with the environment account connection.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the environment account connection.
         */
        public var status: aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnectionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnection) : this() {
            this.arn = x.arn
            this.componentRoleArn = x.componentRoleArn
            this.environmentAccountId = x.environmentAccountId
            this.environmentName = x.environmentName
            this.id = x.id
            this.lastModifiedAt = x.lastModifiedAt
            this.managementAccountId = x.managementAccountId
            this.requestedAt = x.requestedAt
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.EnvironmentAccountConnection = EnvironmentAccountConnection(this)
    }
}
