// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed data of an Proton service resource.
 */
public class Service private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the code repository branch that holds the code that's deployed in Proton.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * The time when the service was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A description of the service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time when the service was last modified.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The service pipeline detail data.
     */
    public val pipeline: aws.sdk.kotlin.services.proton.model.ServicePipeline? = builder.pipeline
    /**
     * The Amazon Resource Name (ARN) of the repository connection. For more information, see [Set up a repository connection](https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol) in the *Proton Administrator Guide* and [Setting up with Proton](https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection) in the *Proton User Guide*.
     */
    public val repositoryConnectionArn: kotlin.String? = builder.repositoryConnectionArn
    /**
     * The ID of the source code repository.
     */
    public val repositoryId: kotlin.String? = builder.repositoryId
    /**
     * The formatted specification that defines the service.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The status of the service.
     */
    public val status: aws.sdk.kotlin.services.proton.model.ServiceStatus? = builder.status
    /**
     * A service status message.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The name of the service template.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.Service = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Service(")
        append("arn=$arn,")
        append("branchName=$branchName,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("name=$name,")
        append("pipeline=$pipeline,")
        append("repositoryConnectionArn=$repositoryConnectionArn,")
        append("repositoryId=$repositoryId,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("statusMessage=*** Sensitive Data Redacted ***,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (branchName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pipeline?.hashCode() ?: 0)
        result = 31 * result + (repositoryConnectionArn?.hashCode() ?: 0)
        result = 31 * result + (repositoryId?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Service

        if (arn != other.arn) return false
        if (branchName != other.branchName) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (name != other.name) return false
        if (pipeline != other.pipeline) return false
        if (repositoryConnectionArn != other.repositoryConnectionArn) return false
        if (repositoryId != other.repositoryId) return false
        if (spec != other.spec) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.Service = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the code repository branch that holds the code that's deployed in Proton.
         */
        public var branchName: kotlin.String? = null
        /**
         * The time when the service was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the service.
         */
        public var description: kotlin.String? = null
        /**
         * The time when the service was last modified.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * The service pipeline detail data.
         */
        public var pipeline: aws.sdk.kotlin.services.proton.model.ServicePipeline? = null
        /**
         * The Amazon Resource Name (ARN) of the repository connection. For more information, see [Set up a repository connection](https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol) in the *Proton Administrator Guide* and [Setting up with Proton](https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection) in the *Proton User Guide*.
         */
        public var repositoryConnectionArn: kotlin.String? = null
        /**
         * The ID of the source code repository.
         */
        public var repositoryId: kotlin.String? = null
        /**
         * The formatted specification that defines the service.
         */
        public var spec: kotlin.String? = null
        /**
         * The status of the service.
         */
        public var status: aws.sdk.kotlin.services.proton.model.ServiceStatus? = null
        /**
         * A service status message.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The name of the service template.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.Service) : this() {
            this.arn = x.arn
            this.branchName = x.branchName
            this.createdAt = x.createdAt
            this.description = x.description
            this.lastModifiedAt = x.lastModifiedAt
            this.name = x.name
            this.pipeline = x.pipeline
            this.repositoryConnectionArn = x.repositoryConnectionArn
            this.repositoryId = x.repositoryId
            this.spec = x.spec
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.Service = Service(this)

        /**
         * construct an [aws.sdk.kotlin.services.proton.model.ServicePipeline] inside the given [block]
         */
        public fun pipeline(block: aws.sdk.kotlin.services.proton.model.ServicePipeline.Builder.() -> kotlin.Unit) {
            this.pipeline = aws.sdk.kotlin.services.proton.model.ServicePipeline.invoke(block)
        }
    }
}
