// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary data of an Proton service instance resource.
 */
public class ServiceInstanceSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service instance.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the service instance was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The service instance deployment status.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * A service instance deployment status message.
     */
    public val deploymentStatusMessage: kotlin.String? = builder.deploymentStatusMessage
    /**
     * The name of the environment that the service instance was deployed into.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The time when a deployment of the service was last attempted.
     */
    public val lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentAttemptedAt
    /**
     * The time when the service was last deployed successfully.
     */
    public val lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentSucceededAt
    /**
     * The name of the service instance.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the service that the service instance belongs to.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The service instance template major version.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The service instance template minor version.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion
    /**
     * The name of the service template.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.ServiceInstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceInstanceSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deploymentStatus=$deploymentStatus,")
        append("deploymentStatusMessage=*** Sensitive Data Redacted ***,")
        append("environmentName=$environmentName,")
        append("lastDeploymentAttemptedAt=$lastDeploymentAttemptedAt,")
        append("lastDeploymentSucceededAt=$lastDeploymentSucceededAt,")
        append("name=$name,")
        append("serviceName=$serviceName,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentAttemptedAt?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentSucceededAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceInstanceSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (deploymentStatusMessage != other.deploymentStatusMessage) return false
        if (environmentName != other.environmentName) return false
        if (lastDeploymentAttemptedAt != other.lastDeploymentAttemptedAt) return false
        if (lastDeploymentSucceededAt != other.lastDeploymentSucceededAt) return false
        if (name != other.name) return false
        if (serviceName != other.serviceName) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.ServiceInstanceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service instance.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the service instance was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The service instance deployment status.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = null
        /**
         * A service instance deployment status message.
         */
        public var deploymentStatusMessage: kotlin.String? = null
        /**
         * The name of the environment that the service instance was deployed into.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The time when a deployment of the service was last attempted.
         */
        public var lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the service was last deployed successfully.
         */
        public var lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service instance.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the service that the service instance belongs to.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The service instance template major version.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The service instance template minor version.
         */
        public var templateMinorVersion: kotlin.String? = null
        /**
         * The name of the service template.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.ServiceInstanceSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deploymentStatus = x.deploymentStatus
            this.deploymentStatusMessage = x.deploymentStatusMessage
            this.environmentName = x.environmentName
            this.lastDeploymentAttemptedAt = x.lastDeploymentAttemptedAt
            this.lastDeploymentSucceededAt = x.lastDeploymentSucceededAt
            this.name = x.name
            this.serviceName = x.serviceName
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.ServiceInstanceSummary = ServiceInstanceSummary(this)
    }
}
