// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed data of an Proton service instance pipeline resource.
 */
public class ServicePipeline private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service pipeline.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the service pipeline was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The deployment status of the service pipeline.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * A service pipeline deployment status message.
     */
    public val deploymentStatusMessage: kotlin.String? = builder.deploymentStatusMessage
    /**
     * The time when a deployment of the service pipeline was last attempted.
     */
    public val lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentAttemptedAt
    /**
     * The time when the service pipeline was last deployed successfully.
     */
    public val lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDeploymentSucceededAt
    /**
     * The service spec that was used to create the service pipeline.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The major version of the service template that was used to create the service pipeline.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the service template that was used to create the service pipeline.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion
    /**
     * The name of the service template that was used to create the service pipeline.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.ServicePipeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServicePipeline(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deploymentStatus=$deploymentStatus,")
        append("deploymentStatusMessage=*** Sensitive Data Redacted ***,")
        append("lastDeploymentAttemptedAt=$lastDeploymentAttemptedAt,")
        append("lastDeploymentSucceededAt=$lastDeploymentSucceededAt,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentAttemptedAt?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentSucceededAt?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServicePipeline

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (deploymentStatusMessage != other.deploymentStatusMessage) return false
        if (lastDeploymentAttemptedAt != other.lastDeploymentAttemptedAt) return false
        if (lastDeploymentSucceededAt != other.lastDeploymentSucceededAt) return false
        if (spec != other.spec) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.ServicePipeline = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service pipeline.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the service pipeline was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment status of the service pipeline.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.proton.model.DeploymentStatus? = null
        /**
         * A service pipeline deployment status message.
         */
        public var deploymentStatusMessage: kotlin.String? = null
        /**
         * The time when a deployment of the service pipeline was last attempted.
         */
        public var lastDeploymentAttemptedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the service pipeline was last deployed successfully.
         */
        public var lastDeploymentSucceededAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The service spec that was used to create the service pipeline.
         */
        public var spec: kotlin.String? = null
        /**
         * The major version of the service template that was used to create the service pipeline.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the service template that was used to create the service pipeline.
         */
        public var templateMinorVersion: kotlin.String? = null
        /**
         * The name of the service template that was used to create the service pipeline.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.ServicePipeline) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deploymentStatus = x.deploymentStatus
            this.deploymentStatusMessage = x.deploymentStatusMessage
            this.lastDeploymentAttemptedAt = x.lastDeploymentAttemptedAt
            this.lastDeploymentSucceededAt = x.lastDeploymentSucceededAt
            this.spec = x.spec
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.ServicePipeline = ServicePipeline(this)
    }
}
