// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary data of an Proton service template resource.
 */
public class ServiceTemplateSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service template.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the service template was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A description of the service template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The service template name as displayed in the developer interface.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The time when the service template was last modified.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The name of the service template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If `pipelineProvisioning` is `true`, a service pipeline is included in the service template, otherwise a service pipeline *isn't* included in the service template.
     */
    public val pipelineProvisioning: aws.sdk.kotlin.services.proton.model.Provisioning? = builder.pipelineProvisioning
    /**
     * The recommended version of the service template.
     */
    public val recommendedVersion: kotlin.String? = builder.recommendedVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.ServiceTemplateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceTemplateSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("name=$name,")
        append("pipelineProvisioning=$pipelineProvisioning,")
        append("recommendedVersion=$recommendedVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pipelineProvisioning?.hashCode() ?: 0)
        result = 31 * result + (recommendedVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceTemplateSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (name != other.name) return false
        if (pipelineProvisioning != other.pipelineProvisioning) return false
        if (recommendedVersion != other.recommendedVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.ServiceTemplateSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service template.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the service template was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the service template.
         */
        public var description: kotlin.String? = null
        /**
         * The service template name as displayed in the developer interface.
         */
        public var displayName: kotlin.String? = null
        /**
         * The time when the service template was last modified.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service template.
         */
        public var name: kotlin.String? = null
        /**
         * If `pipelineProvisioning` is `true`, a service pipeline is included in the service template, otherwise a service pipeline *isn't* included in the service template.
         */
        public var pipelineProvisioning: aws.sdk.kotlin.services.proton.model.Provisioning? = null
        /**
         * The recommended version of the service template.
         */
        public var recommendedVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.ServiceTemplateSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.displayName = x.displayName
            this.lastModifiedAt = x.lastModifiedAt
            this.name = x.name
            this.pipelineProvisioning = x.pipelineProvisioning
            this.recommendedVersion = x.recommendedVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.ServiceTemplateSummary = ServiceTemplateSummary(this)
    }
}
