// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class UpdateEnvironmentAccountConnectionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
     *
     * The environment account connection must have a `componentRoleArn` to allow directly defined components to be associated with any environments running in the account.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val componentRoleArn: kotlin.String? = builder.componentRoleArn
    /**
     * The ID of the environment account connection to update.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that's associated with the environment account connection to update.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentAccountConnectionRequest(")
        append("componentRoleArn=$componentRoleArn,")
        append("id=$id,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentRoleArn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentAccountConnectionRequest

        if (componentRoleArn != other.componentRoleArn) return false
        if (id != other.id) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
         *
         * The environment account connection must have a `componentRoleArn` to allow directly defined components to be associated with any environments running in the account.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var componentRoleArn: kotlin.String? = null
        /**
         * The ID of the environment account connection to update.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that's associated with the environment account connection to update.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionRequest) : this() {
            this.componentRoleArn = x.componentRoleArn
            this.id = x.id
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentAccountConnectionRequest = UpdateEnvironmentAccountConnectionRequest(this)
    }
}
