// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class UpdateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
     *
     * The environment must have a `componentRoleArn` to allow directly defined components to be associated with the environment.
     *
     * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
     */
    public val componentRoleArn: kotlin.String? = builder.componentRoleArn
    /**
     * There are four modes for updating an environment. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).
     */
    public val deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = builder.deploymentType
    /**
     * A description of the environment update.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the environment account connection.
     *
     * You can only update to a new environment account connection if it was created in the same environment account that the current environment account connection was created in and is associated with the current environment.
     */
    public val environmentAccountConnectionId: kotlin.String? = builder.environmentAccountConnectionId
    /**
     * The name of the environment to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services your behalf.
     */
    public val protonServiceRoleArn: kotlin.String? = builder.protonServiceRoleArn
    /**
     * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
     */
    public val provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput? = builder.provisioningRepository
    /**
     * The formatted specification that defines the update.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The major version of the environment to update.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the environment to update.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentRequest(")
        append("componentRoleArn=$componentRoleArn,")
        append("deploymentType=$deploymentType,")
        append("description=*** Sensitive Data Redacted ***,")
        append("environmentAccountConnectionId=$environmentAccountConnectionId,")
        append("name=$name,")
        append("protonServiceRoleArn=$protonServiceRoleArn,")
        append("provisioningRepository=$provisioningRepository,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentRoleArn?.hashCode() ?: 0
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentAccountConnectionId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protonServiceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (provisioningRepository?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentRequest

        if (componentRoleArn != other.componentRoleArn) return false
        if (deploymentType != other.deploymentType) return false
        if (description != other.description) return false
        if (environmentAccountConnectionId != other.environmentAccountConnectionId) return false
        if (name != other.name) return false
        if (protonServiceRoleArn != other.protonServiceRoleArn) return false
        if (provisioningRepository != other.provisioningRepository) return false
        if (spec != other.spec) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.
         *
         * The environment must have a `componentRoleArn` to allow directly defined components to be associated with the environment.
         *
         * For more information about components, see [Proton components](https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html) in the *Proton Administrator Guide*.
         */
        public var componentRoleArn: kotlin.String? = null
        /**
         * There are four modes for updating an environment. The `deploymentType` field defines the mode.
         *
         * `NONE`
         *
         * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
         *
         * `CURRENT_VERSION`
         *
         * In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
         *
         * `MINOR_VERSION`
         *
         * In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
         *
         * `MAJOR_VERSION`
         *
         * In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).
         */
        public var deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = null
        /**
         * A description of the environment update.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the environment account connection.
         *
         * You can only update to a new environment account connection if it was created in the same environment account that the current environment account connection was created in and is associated with the current environment.
         */
        public var environmentAccountConnectionId: kotlin.String? = null
        /**
         * The name of the environment to update.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services your behalf.
         */
        public var protonServiceRoleArn: kotlin.String? = null
        /**
         * The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.
         */
        public var provisioningRepository: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput? = null
        /**
         * The formatted specification that defines the update.
         */
        public var spec: kotlin.String? = null
        /**
         * The major version of the environment to update.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the environment to update.
         */
        public var templateMinorVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.UpdateEnvironmentRequest) : this() {
            this.componentRoleArn = x.componentRoleArn
            this.deploymentType = x.deploymentType
            this.description = x.description
            this.environmentAccountConnectionId = x.environmentAccountConnectionId
            this.name = x.name
            this.protonServiceRoleArn = x.protonServiceRoleArn
            this.provisioningRepository = x.provisioningRepository
            this.spec = x.spec
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.UpdateEnvironmentRequest = UpdateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.proton.model.RepositoryBranchInput] inside the given [block]
         */
        public fun provisioningRepository(block: aws.sdk.kotlin.services.proton.model.RepositoryBranchInput.Builder.() -> kotlin.Unit) {
            this.provisioningRepository = aws.sdk.kotlin.services.proton.model.RepositoryBranchInput.invoke(block)
        }
    }
}
