// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class UpdateServiceInstanceRequest private constructor(builder: Builder) {
    /**
     * The deployment type. It defines the mode for updating a service instance, as follows:
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this deployment type.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that's higher than the major version in use and a minor version.
     */
    public val deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = builder.deploymentType
    /**
     * The name of the service instance to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the service that the service instance belongs to.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The formatted specification that defines the service instance update.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The major version of the service template to update.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the service template to update.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServiceInstanceRequest(")
        append("deploymentType=$deploymentType,")
        append("name=$name,")
        append("serviceName=$serviceName,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentType?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServiceInstanceRequest

        if (deploymentType != other.deploymentType) return false
        if (name != other.name) return false
        if (serviceName != other.serviceName) return false
        if (spec != other.spec) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The deployment type. It defines the mode for updating a service instance, as follows:
         *
         * `NONE`
         *
         * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
         *
         * `CURRENT_VERSION`
         *
         * In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this deployment type.
         *
         * `MINOR_VERSION`
         *
         * In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.
         *
         * `MAJOR_VERSION`
         *
         * In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that's higher than the major version in use and a minor version.
         */
        public var deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = null
        /**
         * The name of the service instance to update.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the service that the service instance belongs to.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The formatted specification that defines the service instance update.
         */
        public var spec: kotlin.String? = null
        /**
         * The major version of the service template to update.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the service template to update.
         */
        public var templateMinorVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceRequest) : this() {
            this.deploymentType = x.deploymentType
            this.name = x.name
            this.serviceName = x.serviceName
            this.spec = x.spec
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.UpdateServiceInstanceRequest = UpdateServiceInstanceRequest(this)
    }
}
