// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.model



public class UpdateServicePipelineRequest private constructor(builder: Builder) {
    /**
     * The deployment type.
     *
     * There are four modes for updating a service pipeline. The `deploymentType` field defines the mode.
     *
     * `NONE`
     *
     * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
     *
     * `CURRENT_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
     *
     * `MINOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.
     *
     * `MAJOR_VERSION`
     *
     * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that's higher than the major version in use and a minor version.
     */
    public val deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = builder.deploymentType
    /**
     * The name of the service to that the pipeline is associated with.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The spec for the service pipeline to update.
     */
    public val spec: kotlin.String? = builder.spec
    /**
     * The major version of the service template that was used to create the service that the pipeline is associated with.
     */
    public val templateMajorVersion: kotlin.String? = builder.templateMajorVersion
    /**
     * The minor version of the service template that was used to create the service that the pipeline is associated with.
     */
    public val templateMinorVersion: kotlin.String? = builder.templateMinorVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.proton.model.UpdateServicePipelineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServicePipelineRequest(")
        append("deploymentType=$deploymentType,")
        append("serviceName=$serviceName,")
        append("spec=*** Sensitive Data Redacted ***,")
        append("templateMajorVersion=$templateMajorVersion,")
        append("templateMinorVersion=$templateMinorVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentType?.hashCode() ?: 0
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (spec?.hashCode() ?: 0)
        result = 31 * result + (templateMajorVersion?.hashCode() ?: 0)
        result = 31 * result + (templateMinorVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServicePipelineRequest

        if (deploymentType != other.deploymentType) return false
        if (serviceName != other.serviceName) return false
        if (spec != other.spec) return false
        if (templateMajorVersion != other.templateMajorVersion) return false
        if (templateMinorVersion != other.templateMinorVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.proton.model.UpdateServicePipelineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The deployment type.
         *
         * There are four modes for updating a service pipeline. The `deploymentType` field defines the mode.
         *
         * `NONE`
         *
         * In this mode, a deployment *doesn't* occur. Only the requested metadata parameters are updated.
         *
         * `CURRENT_VERSION`
         *
         * In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. *Don’t* include major or minor version parameters when you use this `deployment-type`.
         *
         * `MINOR_VERSION`
         *
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.
         *
         * `MAJOR_VERSION`
         *
         * In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that's higher than the major version in use and a minor version.
         */
        public var deploymentType: aws.sdk.kotlin.services.proton.model.DeploymentUpdateType? = null
        /**
         * The name of the service to that the pipeline is associated with.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The spec for the service pipeline to update.
         */
        public var spec: kotlin.String? = null
        /**
         * The major version of the service template that was used to create the service that the pipeline is associated with.
         */
        public var templateMajorVersion: kotlin.String? = null
        /**
         * The minor version of the service template that was used to create the service that the pipeline is associated with.
         */
        public var templateMinorVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.proton.model.UpdateServicePipelineRequest) : this() {
            this.deploymentType = x.deploymentType
            this.serviceName = x.serviceName
            this.spec = x.spec
            this.templateMajorVersion = x.templateMajorVersion
            this.templateMinorVersion = x.templateMinorVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.proton.model.UpdateServicePipelineRequest = UpdateServicePipelineRequest(this)
    }
}
