// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.paginators

import aws.sdk.kotlin.services.proton.ProtonClient
import aws.sdk.kotlin.services.proton.model.ListRepositorySyncDefinitionsRequest
import aws.sdk.kotlin.services.proton.model.ListRepositorySyncDefinitionsResponse
import aws.sdk.kotlin.services.proton.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.proton.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.proton.model.RepositorySyncDefinition
import aws.sdk.kotlin.services.proton.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListRepositorySyncDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositorySyncDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositorySyncDefinitionsResponse]
 */
public fun ProtonClient.listRepositorySyncDefinitionsPaginated(initialRequest: ListRepositorySyncDefinitionsRequest): Flow<ListRepositorySyncDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositorySyncDefinitionsPaginated.listRepositorySyncDefinitions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositorySyncDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositorySyncDefinitionsResponse]
 */
public fun ProtonClient.listRepositorySyncDefinitionsPaginated(block: ListRepositorySyncDefinitionsRequest.Builder.() -> Unit): Flow<ListRepositorySyncDefinitionsResponse> =
    listRepositorySyncDefinitionsPaginated(ListRepositorySyncDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositorySyncDefinitionsPaginated]
 * to access the nested member [RepositorySyncDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositorySyncDefinition]
 */
@JvmName("listRepositorySyncDefinitionsResponseRepositorySyncDefinition")
public fun Flow<ListRepositorySyncDefinitionsResponse>.syncDefinitions(): Flow<RepositorySyncDefinition> =
    transform() { response ->
        response.syncDefinitions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun ProtonClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun ProtonClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
