// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.proton.model.EnvironmentTemplate
import aws.sdk.kotlin.services.proton.model.GetEnvironmentTemplateResponse
import aws.sdk.kotlin.services.proton.model.ProtonException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetEnvironmentTemplateOperationDeserializer: HttpDeserialize<GetEnvironmentTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEnvironmentTemplateResponse {
        if (!response.status.isSuccess()) {
            throwGetEnvironmentTemplateError(context, response)
        }
        val builder = GetEnvironmentTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEnvironmentTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEnvironmentTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ProtonException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ProtonException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEnvironmentTemplateOperationBody(builder: GetEnvironmentTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENVIRONMENTTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("environmentTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENVIRONMENTTEMPLATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENVIRONMENTTEMPLATE_DESCRIPTOR.index -> builder.environmentTemplate = deserializeEnvironmentTemplateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
