// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.proton.model.GetRepositorySyncStatusResponse
import aws.sdk.kotlin.services.proton.model.ProtonException
import aws.sdk.kotlin.services.proton.model.RepositorySyncAttempt
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRepositorySyncStatusOperationDeserializer: HttpDeserialize<GetRepositorySyncStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRepositorySyncStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetRepositorySyncStatusError(context, response)
        }
        val builder = GetRepositorySyncStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRepositorySyncStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRepositorySyncStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ProtonException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ProtonException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRepositorySyncStatusOperationBody(builder: GetRepositorySyncStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LATESTSYNC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestSync"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LATESTSYNC_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LATESTSYNC_DESCRIPTOR.index -> builder.latestSync = deserializeRepositorySyncAttemptDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
