// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.proton.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.proton.model.GetTemplateSyncStatusResponse
import aws.sdk.kotlin.services.proton.model.ProtonException
import aws.sdk.kotlin.services.proton.model.ResourceSyncAttempt
import aws.sdk.kotlin.services.proton.model.Revision
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTemplateSyncStatusOperationDeserializer: HttpDeserialize<GetTemplateSyncStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTemplateSyncStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetTemplateSyncStatusError(context, response)
        }
        val builder = GetTemplateSyncStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTemplateSyncStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTemplateSyncStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ProtonException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ProtonException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTemplateSyncStatusOperationBody(builder: GetTemplateSyncStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESIREDSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("desiredState"))
    val LATESTSUCCESSFULSYNC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestSuccessfulSync"))
    val LATESTSYNC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestSync"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESIREDSTATE_DESCRIPTOR)
        field(LATESTSUCCESSFULSYNC_DESCRIPTOR)
        field(LATESTSYNC_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESIREDSTATE_DESCRIPTOR.index -> builder.desiredState = deserializeRevisionDocument(deserializer)
                LATESTSUCCESSFULSYNC_DESCRIPTOR.index -> builder.latestSuccessfulSync = deserializeResourceSyncAttemptDocument(deserializer)
                LATESTSYNC_DESCRIPTOR.index -> builder.latestSync = deserializeResourceSyncAttemptDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
