// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



class CreateLedgerRequest private constructor(builder: Builder) {
    /**
     * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (`true`) by default.
     *
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see [Encryption at rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html) in the *Amazon QLDB Developer Guide*.
     *
     * Use one of the following options to specify this parameter:
     * + `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.
     * + **Undefined**: By default, use an Amazon Web Services owned KMS key.
     * + **A valid symmetric customer managed KMS key**: Use the specified KMS key in your account that you create, own, and manage.Amazon QLDB does not support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
     *
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * For more information, see [Key identifiers (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) in the *Key Management Service Developer Guide*.
     */
    val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The name of the ledger that you want to create. The name must be unique among all of the ledgers in your Amazon Web Services account in the current Region.
     *
     * Naming constraints for ledger names are defined in [Quotas in Amazon QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming) in the *Amazon QLDB Developer Guide*.
     */
    val name: kotlin.String? = builder.name
    /**
     * The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:
     * + `ALLOW_ALL`: A legacy permissions mode that enables access control with API-level granularity for ledgers.This mode allows users who have the `SendCommand` API permission for this ledger to run all PartiQL commands (hence, `ALLOW_ALL`) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     * + `STANDARD`: (*Recommended*) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the `SendCommand` API permission for the ledger. For information, see [Getting started with the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html) in the *Amazon QLDB Developer Guide*.
     *
     * We strongly recommend using the `STANDARD` permissions mode to maximize the security of your ledger data.
     */
    val permissionsMode: aws.sdk.kotlin.services.qldb.model.PermissionsMode? = builder.permissionsMode
    /**
     * The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.
     */
    val tags: Map<String, String?>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLedgerRequest(")
        append("deletionProtection=$deletionProtection,")
        append("kmsKey=$kmsKey,")
        append("name=$name,")
        append("permissionsMode=$permissionsMode,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionsMode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLedgerRequest

        if (deletionProtection != other.deletionProtection) return false
        if (kmsKey != other.kmsKey) return false
        if (name != other.name) return false
        if (permissionsMode != other.permissionsMode) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (`true`) by default.
         *
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see [Encryption at rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html) in the *Amazon QLDB Developer Guide*.
         *
         * Use one of the following options to specify this parameter:
         * + `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.
         * + **Undefined**: By default, use an Amazon Web Services owned KMS key.
         * + **A valid symmetric customer managed KMS key**: Use the specified KMS key in your account that you create, own, and manage.Amazon QLDB does not support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
         *
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * For more information, see [Key identifiers (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) in the *Key Management Service Developer Guide*.
         */
        var kmsKey: kotlin.String? = null
        /**
         * The name of the ledger that you want to create. The name must be unique among all of the ledgers in your Amazon Web Services account in the current Region.
         *
         * Naming constraints for ledger names are defined in [Quotas in Amazon QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming) in the *Amazon QLDB Developer Guide*.
         */
        var name: kotlin.String? = null
        /**
         * The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:
         * + `ALLOW_ALL`: A legacy permissions mode that enables access control with API-level granularity for ledgers.This mode allows users who have the `SendCommand` API permission for this ledger to run all PartiQL commands (hence, `ALLOW_ALL`) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.
         * + `STANDARD`: (*Recommended*) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the `SendCommand` API permission for the ledger. For information, see [Getting started with the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html) in the *Amazon QLDB Developer Guide*.
         *
         * We strongly recommend using the `STANDARD` permissions mode to maximize the security of your ledger data.
         */
        var permissionsMode: aws.sdk.kotlin.services.qldb.model.PermissionsMode? = null
        /**
         * The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.
         */
        var tags: Map<String, String?>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.kmsKey = x.kmsKey
            this.name = x.name
            this.permissionsMode = x.permissionsMode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest = CreateLedgerRequest(this)
    }
}
