// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateLedgerResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the ledger.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (`true`) by default.
     *
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the ledger.
     */
    val name: kotlin.String? = builder.name
    /**
     * The permissions mode of the ledger that you created.
     */
    val permissionsMode: aws.sdk.kotlin.services.qldb.model.PermissionsMode? = builder.permissionsMode
    /**
     * The current status of the ledger.
     */
    val state: aws.sdk.kotlin.services.qldb.model.LedgerState? = builder.state

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLedgerResponse(")
        append("arn=$arn,")
        append("creationDateTime=$creationDateTime,")
        append("deletionProtection=$deletionProtection,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("permissionsMode=$permissionsMode,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionsMode?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLedgerResponse

        if (arn != other.arn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (deletionProtection != other.deletionProtection) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (permissionsMode != other.permissionsMode) return false
        if (state != other.state) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the ledger.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (`true`) by default.
         *
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the ledger.
         */
        var name: kotlin.String? = null
        /**
         * The permissions mode of the ledger that you created.
         */
        var permissionsMode: aws.sdk.kotlin.services.qldb.model.PermissionsMode? = null
        /**
         * The current status of the ledger.
         */
        var state: aws.sdk.kotlin.services.qldb.model.LedgerState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse) : this() {
            this.arn = x.arn
            this.creationDateTime = x.creationDateTime
            this.deletionProtection = x.deletionProtection
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.permissionsMode = x.permissionsMode
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse = CreateLedgerResponse(this)
    }
}
