// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class ExportJournalToS3Request private constructor(builder: Builder) {
    /**
     * The exclusive end date and time for the range of journal contents to export.
     *
     * The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
     *
     * The `ExclusiveEndTime` must be less than or equal to the current UTC date and time.
     */
    val exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time for the range of journal contents to export.
     *
     * The `InclusiveStartTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
     *
     * The `InclusiveStartTime` must be before `ExclusiveEndTime`.
     *
     * If you provide an `InclusiveStartTime` that is before the ledger's `CreationDateTime`, Amazon QLDB defaults it to the ledger's `CreationDateTime`.
     */
    val inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.inclusiveStartTime
    /**
     * The name of the ledger.
     */
    val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The output format of your exported journal data. If this parameter is not specified, the exported data defaults to `ION_TEXT` format.
     */
    val outputFormat: aws.sdk.kotlin.services.qldb.model.OutputFormat? = builder.outputFormat
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:
     * + Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     * + (Optional) Use your customer managed key in Key Management Service (KMS) for server-side encryption of your exported data.
     *
     * To pass a role to QLDB when requesting a journal export, you must have permissions to perform the `iam:PassRole` action on the IAM role resource. This is required for all journal export requests.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The configuration settings of the Amazon S3 bucket destination for your export request.
     */
    val s3ExportConfiguration: aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration? = builder.s3ExportConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportJournalToS3Request(")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("name=$name,")
        append("outputFormat=$outputFormat,")
        append("roleArn=$roleArn,")
        append("s3ExportConfiguration=$s3ExportConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveEndTime?.hashCode() ?: 0
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3ExportConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportJournalToS3Request

        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (name != other.name) return false
        if (outputFormat != other.outputFormat) return false
        if (roleArn != other.roleArn) return false
        if (s3ExportConfiguration != other.s3ExportConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request = Builder(this).apply(block).build()

    class Builder {
        /**
         * The exclusive end date and time for the range of journal contents to export.
         *
         * The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
         *
         * The `ExclusiveEndTime` must be less than or equal to the current UTC date and time.
         */
        var exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The inclusive start date and time for the range of journal contents to export.
         *
         * The `InclusiveStartTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
         *
         * The `InclusiveStartTime` must be before `ExclusiveEndTime`.
         *
         * If you provide an `InclusiveStartTime` that is before the ledger's `CreationDateTime`, Amazon QLDB defaults it to the ledger's `CreationDateTime`.
         */
        var inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the ledger.
         */
        var name: kotlin.String? = null
        /**
         * The output format of your exported journal data. If this parameter is not specified, the exported data defaults to `ION_TEXT` format.
         */
        var outputFormat: aws.sdk.kotlin.services.qldb.model.OutputFormat? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:
         * + Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * + (Optional) Use your customer managed key in Key Management Service (KMS) for server-side encryption of your exported data.
         *
         * To pass a role to QLDB when requesting a journal export, you must have permissions to perform the `iam:PassRole` action on the IAM role resource. This is required for all journal export requests.
         */
        var roleArn: kotlin.String? = null
        /**
         * The configuration settings of the Amazon S3 bucket destination for your export request.
         */
        var s3ExportConfiguration: aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request) : this() {
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.name = x.name
            this.outputFormat = x.outputFormat
            this.roleArn = x.roleArn
            this.s3ExportConfiguration = x.s3ExportConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request = ExportJournalToS3Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration] inside the given [block]
         */
        fun s3ExportConfiguration(block: aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration.Builder.() -> kotlin.Unit) {
            this.s3ExportConfiguration = aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration.invoke(block)
        }
    }
}
