// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the encryption of data at rest in an Amazon QLDB ledger. This includes the current status, the key in Key Management Service (KMS), and when the key became inaccessible (in the case of an error).
 *
 * For more information, see [Encryption at rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html) in the *Amazon QLDB Developer Guide*.
 */
class LedgerEncryptionDescription private constructor(builder: Builder) {
    /**
     * The current state of encryption at rest for the ledger. This can be one of the following values:
     * + `ENABLED`: Encryption is fully enabled using the specified key.
     * + `UPDATING`: The ledger is actively processing the specified key change.Key changes in QLDB are asynchronous. The ledger is fully accessible without any performance impact while the key change is being processed. The amount of time it takes to update a key varies depending on the ledger size.
     * + `KMS_KEY_INACCESSIBLE`: The specified customer managed KMS key is not accessible, and the ledger is impaired. Either the key was disabled or deleted, or the grants on the key were revoked. When a ledger is impaired, it is not accessible and does not accept any read or write requests.An impaired ledger automatically returns to an active state after you restore the grants on the key, or re-enable the key that was disabled. However, deleting a customer managed KMS key is irreversible. After a key is deleted, you can no longer access the ledgers that are protected with that key, and the data becomes unrecoverable permanently.
     */
    val encryptionStatus: aws.sdk.kotlin.services.qldb.model.EncryptionStatus? = builder.encryptionStatus
    /**
     * The date and time, in epoch time format, when the KMS key first became inaccessible, in the case of an error. (Epoch time format is the number of seconds that have elapsed since 12:00:00 AM January 1, 1970 UTC.)
     *
     * This parameter is undefined if the KMS key is accessible.
     */
    val inaccessibleKmsKeyDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.inaccessibleKmsKeyDateTime
    /**
     * The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.LedgerEncryptionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LedgerEncryptionDescription(")
        append("encryptionStatus=$encryptionStatus,")
        append("inaccessibleKmsKeyDateTime=$inaccessibleKmsKeyDateTime,")
        append("kmsKeyArn=$kmsKeyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionStatus?.hashCode() ?: 0
        result = 31 * result + (inaccessibleKmsKeyDateTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LedgerEncryptionDescription

        if (encryptionStatus != other.encryptionStatus) return false
        if (inaccessibleKmsKeyDateTime != other.inaccessibleKmsKeyDateTime) return false
        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.LedgerEncryptionDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The current state of encryption at rest for the ledger. This can be one of the following values:
         * + `ENABLED`: Encryption is fully enabled using the specified key.
         * + `UPDATING`: The ledger is actively processing the specified key change.Key changes in QLDB are asynchronous. The ledger is fully accessible without any performance impact while the key change is being processed. The amount of time it takes to update a key varies depending on the ledger size.
         * + `KMS_KEY_INACCESSIBLE`: The specified customer managed KMS key is not accessible, and the ledger is impaired. Either the key was disabled or deleted, or the grants on the key were revoked. When a ledger is impaired, it is not accessible and does not accept any read or write requests.An impaired ledger automatically returns to an active state after you restore the grants on the key, or re-enable the key that was disabled. However, deleting a customer managed KMS key is irreversible. After a key is deleted, you can no longer access the ledgers that are protected with that key, and the data becomes unrecoverable permanently.
         */
        var encryptionStatus: aws.sdk.kotlin.services.qldb.model.EncryptionStatus? = null
        /**
         * The date and time, in epoch time format, when the KMS key first became inaccessible, in the case of an error. (Epoch time format is the number of seconds that have elapsed since 12:00:00 AM January 1, 1970 UTC.)
         *
         * This parameter is undefined if the KMS key is accessible.
         */
        var inaccessibleKmsKeyDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
         */
        var kmsKeyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.LedgerEncryptionDescription) : this() {
            this.encryptionStatus = x.encryptionStatus
            this.inaccessibleKmsKeyDateTime = x.inaccessibleKmsKeyDateTime
            this.kmsKeyArn = x.kmsKeyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.LedgerEncryptionDescription = LedgerEncryptionDescription(this)
    }
}
