// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.paginators

import aws.sdk.kotlin.services.qldb.QldbClient
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsResponse
import aws.sdk.kotlin.services.qldb.model.ListLedgersRequest
import aws.sdk.kotlin.services.qldb.model.ListLedgersResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListJournalKinesisStreamsForLedgerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJournalKinesisStreamsForLedgerRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalKinesisStreamsForLedgerResponse]
 */
fun QldbClient.listJournalKinesisStreamsForLedgerPaginated(initialRequest: ListJournalKinesisStreamsForLedgerRequest): Flow<ListJournalKinesisStreamsForLedgerResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJournalKinesisStreamsForLedgerPaginated.listJournalKinesisStreamsForLedger(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJournalKinesisStreamsForLedgerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalKinesisStreamsForLedgerResponse]
 */
fun QldbClient.listJournalKinesisStreamsForLedgerPaginated(block: ListJournalKinesisStreamsForLedgerRequest.Builder.() -> Unit): Flow<ListJournalKinesisStreamsForLedgerResponse> =
    listJournalKinesisStreamsForLedgerPaginated(ListJournalKinesisStreamsForLedgerRequest.Builder().apply(block).build())

/**
 * Paginate over [ListJournalS3ExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJournalS3ExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalS3ExportsResponse]
 */
fun QldbClient.listJournalS3ExportsPaginated(initialRequest: ListJournalS3ExportsRequest): Flow<ListJournalS3ExportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJournalS3ExportsPaginated.listJournalS3Exports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJournalS3ExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalS3ExportsResponse]
 */
fun QldbClient.listJournalS3ExportsPaginated(block: ListJournalS3ExportsRequest.Builder.() -> Unit): Flow<ListJournalS3ExportsResponse> =
    listJournalS3ExportsPaginated(ListJournalS3ExportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListJournalS3ExportsForLedgerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJournalS3ExportsForLedgerRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalS3ExportsForLedgerResponse]
 */
fun QldbClient.listJournalS3ExportsForLedgerPaginated(initialRequest: ListJournalS3ExportsForLedgerRequest): Flow<ListJournalS3ExportsForLedgerResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJournalS3ExportsForLedgerPaginated.listJournalS3ExportsForLedger(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJournalS3ExportsForLedgerResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJournalS3ExportsForLedgerResponse]
 */
fun QldbClient.listJournalS3ExportsForLedgerPaginated(block: ListJournalS3ExportsForLedgerRequest.Builder.() -> Unit): Flow<ListJournalS3ExportsForLedgerResponse> =
    listJournalS3ExportsForLedgerPaginated(ListJournalS3ExportsForLedgerRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLedgersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLedgersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLedgersResponse]
 */
fun QldbClient.listLedgersPaginated(initialRequest: ListLedgersRequest): Flow<ListLedgersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLedgersPaginated.listLedgers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLedgersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLedgersResponse]
 */
fun QldbClient.listLedgersPaginated(block: ListLedgersRequest.Builder.() -> Unit): Flow<ListLedgersResponse> =
    listLedgersPaginated(ListLedgersRequest.Builder().apply(block).build())
