// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldbsession.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.qldbsession.model.AbortTransactionResult
import aws.sdk.kotlin.services.qldbsession.model.CommitTransactionResult
import aws.sdk.kotlin.services.qldbsession.model.EndSessionResult
import aws.sdk.kotlin.services.qldbsession.model.ExecuteStatementResult
import aws.sdk.kotlin.services.qldbsession.model.FetchPageResult
import aws.sdk.kotlin.services.qldbsession.model.QldbSessionException
import aws.sdk.kotlin.services.qldbsession.model.SendCommandResponse
import aws.sdk.kotlin.services.qldbsession.model.StartSessionResult
import aws.sdk.kotlin.services.qldbsession.model.StartTransactionResult
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendCommandOperationDeserializer: HttpDeserialize<SendCommandResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendCommandResponse {
        if (!response.status.isSuccess()) {
            throwSendCommandError(context, response)
        }
        val builder = SendCommandResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendCommandOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSendCommandError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QldbSessionException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "CapacityExceededException" -> CapacityExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSessionException" -> InvalidSessionExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "OccConflictException" -> OccConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateExceededException" -> RateExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QldbSessionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendCommandOperationBody(builder: SendCommandResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ABORTTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AbortTransaction"))
    val COMMITTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CommitTransaction"))
    val ENDSESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndSession"))
    val EXECUTESTATEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExecuteStatement"))
    val FETCHPAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FetchPage"))
    val STARTSESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StartSession"))
    val STARTTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StartTransaction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTTRANSACTION_DESCRIPTOR)
        field(COMMITTRANSACTION_DESCRIPTOR)
        field(ENDSESSION_DESCRIPTOR)
        field(EXECUTESTATEMENT_DESCRIPTOR)
        field(FETCHPAGE_DESCRIPTOR)
        field(STARTSESSION_DESCRIPTOR)
        field(STARTTRANSACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ABORTTRANSACTION_DESCRIPTOR.index -> builder.abortTransaction = deserializeAbortTransactionResultDocument(deserializer)
                COMMITTRANSACTION_DESCRIPTOR.index -> builder.commitTransaction = deserializeCommitTransactionResultDocument(deserializer)
                ENDSESSION_DESCRIPTOR.index -> builder.endSession = deserializeEndSessionResultDocument(deserializer)
                EXECUTESTATEMENT_DESCRIPTOR.index -> builder.executeStatement = deserializeExecuteStatementResultDocument(deserializer)
                FETCHPAGE_DESCRIPTOR.index -> builder.fetchPage = deserializeFetchPageResultDocument(deserializer)
                STARTSESSION_DESCRIPTOR.index -> builder.startSession = deserializeStartSessionResultDocument(deserializer)
                STARTTRANSACTION_DESCRIPTOR.index -> builder.startTransaction = deserializeStartTransactionResultDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
